<?php

use App\Models\Language;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // New languages to add: Turkish, Vietnamese, Chinese
        $newLanguages = [
            [
                'name' => 'Türkçe',
                'code' => 'tr',
                'flag' => 'tr',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Tiếng Việt',
                'code' => 'vi',
                'flag' => 'vn',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => '中文',
                'code' => 'zh',
                'flag' => 'cn',
                'is_rtl' => false,
                'status' => 'active',
            ],
        ];

        foreach ($newLanguages as $lang) {
            $language = Language::updateOrCreate(
                ['code' => $lang['code']],
                $lang
            );
            // Create translation files if they don't exist
            $language->createTranslationFiles();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove the newly added languages
        Language::whereIn('code', ['tr', 'vi', 'zh'])->delete();
    }
};
