<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Chaînes de traduction des plugins de plateforme
    |--------------------------------------------------------------------------
    |
    | Les lignes de langue suivantes sont utilisées par les templates blade
    | des plugins de plateforme pour les pages de paramètres et de configuration.
    |
    */

    // Paramètres généraux
    'general' => [
        'basic_information' => 'Informations de base',
        'basic_information_description' => 'Détails essentiels sur votre application',
        'app_name' => 'Nom de l\'application',
        'app_name_placeholder' => 'Mon super app',
        'app_name_help' => 'Affiché sur l\'écran d\'accueil de l\'appareil',
        'website_url' => 'URL du site web',
        'website_url_placeholder' => 'https://exemple.com',
        'website_url_help' => 'URL complète de votre site web ou application web',
        'configuration' => 'Configuration',
        'configuration_description' => 'Paramètres techniques et identifiants',
        'app_id' => 'ID APPLICATION',
        'app_id_tooltip' => 'Identifiant de paquet unique utilisé par les boutiques d\'applications',
        'app_id_placeholder' => 'com.exemple.app',
        'app_id_help' => 'L\'ID de l\'application ne peut pas être modifié une fois créé',
        'copy' => 'Copier',
        'copied' => 'Copié !',
        'screen_orientation' => 'Orientation de l\'écran',
        'screen_orientation_help' => 'Contrôle comment votre application pivote sur l\'appareil',
        'orientation_system' => 'Système',
        'orientation_portrait' => 'Portrait',
        'orientation_landscape' => 'Paysage',
        'app_language' => 'Langue de l\'application (code ISO)',
        'app_language_help' => 'Langue principale pour le contenu de votre application',
    ],

    // Paramètres de design
    'design' => [
        'layout_template' => 'Modèle de mise en page',
        'layout_template_description' => 'Choisissez la structure de navigation pour votre application',
        'layout_app_bar_drawer' => 'Barre d\'application + Tiroir',
        'layout_app_bar_tabs' => 'Barre d\'application + Onglets de navigation',
        'layout_app_bar' => 'Barre d\'application',
        'layout_blank' => 'Vide',
        'progress_indicator' => 'Indicateur de progression',
        'progress_indicator_help' => 'Style de l\'indicateur de chargement affiché lors du chargement des pages',
        'progress_disable' => 'Désactiver',
        'progress_linear' => 'Linéaire',
        'progress_circular' => 'Circulaire',
        'progress_indicator_color' => 'Couleur de l\'indicateur de progression',
        'progress_indicator_color_help' => 'Couleur de l\'indicateur de progression du chargement',
        'show_app_bar_title' => 'Afficher le titre de la page web actuelle dans la barre d\'application',
        'show_app_bar_title_help' => 'Afficher le titre de la page actuelle dans la barre supérieure',
        'nav_tab_icon_colors' => 'Couleurs des icônes des onglets de navigation',
        'nav_tab_icon_colors_help' => 'Couleur des icônes d\'onglets inactifs en mode clair et sombre',
        'active_tab_colors' => 'Couleurs de l\'onglet actif',
        'active_tab_colors_help' => 'Couleur de l\'onglet sélectionné en mode clair et sombre',
        'light_mode' => 'Mode clair',
        'dark_mode' => 'Mode sombre',
        'theme_colors' => 'Couleurs du thème',
        'theme_colors_description' => 'Couleurs principales qui définissent l\'apparence de votre application',
        'theme_color' => 'Couleur du thème',
        'theme_color_help' => 'Couleur principale utilisée dans toute votre application',
        'enable_dynamic_colors' => 'Activer les couleurs dynamiques Material You (Android 12+)',
        'enable_dynamic_colors_help' => 'Lorsqu\'activé, votre application adaptera les couleurs du fond d\'écran de l\'utilisateur sur les appareils Android 12+. Cela remplace la couleur du thème ci-dessus.',
        'text_color_light' => 'Couleur du texte (Mode clair)',
        'text_color_light_help' => 'Couleur par défaut du texte et des icônes en mode clair',
        'text_color_dark' => 'Couleur du texte (Mode sombre)',
        'text_color_dark_help' => 'Couleur par défaut du texte et des icônes en mode sombre',
    ],

    // Paramètres de l'icône
    'icon' => [
        'app_icon' => 'Icône de l\'application',
        'app_icon_description' => 'Téléversez l\'icône de votre application en tant que fichier ZIP depuis icon.kitchen',
        'current_icon' => 'Icône actuelle',
        'icon_zip_uploaded' => 'ZIP de l\'icône téléversé',
        'icon_zip_uploaded_description' => 'Les icônes extraites sont disponibles pour les plateformes Android et Web',
        'default_icon' => 'Icône par défaut',
        'default_icon_description' => 'Téléversez une icône personnalisée pour remplacer celle par défaut',
        'delete' => 'Supprimer',
        'upload_zip_file' => 'Téléverser le fichier ZIP',
        'upload_zip_help' => 'Fichier ZIP depuis icon.kitchen (MAX. 10 Mo)',
        'how_to_create' => 'Comment créer votre icône :',
        'step_visit' => 'Visitez',
        'step_design' => 'Concevez l\'icône de votre application',
        'step_download' => 'Téléchargez le fichier ZIP contenant toutes les icônes de plateforme',
        'step_upload' => 'Téléversez le fichier ZIP ici',
        'zip_file_info' => 'Le fichier ZIP doit contenir des icônes pour les plateformes Android et Web (Max 10 Mo)',
        'upload_icon' => 'Téléverser l\'icône',
    ],

    // Paramètres de l'écran de démarrage
    'splashscreen' => [
        'appearance' => 'Apparence de l\'écran de démarrage',
        'appearance_description' => 'Personnalisez l\'arrière-plan, la durée d\'affichage et les effets d\'animation',
        'background_type' => 'Type d\'arrière-plan',
        'background_type_color' => 'Couleur unie',
        'background_type_image' => 'Image d\'arrière-plan',
        'background_color' => 'Couleur d\'arrière-plan',
        'background_image' => 'Image d\'arrière-plan',
        'background_image_help' => 'PNG uniquement (MAX. 2 Mo)',
        'delete_background_image' => 'Supprimer l\'image d\'arrière-plan',
        'display_duration' => 'Durée d\'affichage :',
        'seconds' => 'secondes',
        'animation_effect' => 'Effet d\'animation',
        'animation_fade' => 'Fondu',
        'animation_slide' => 'Glissement',
        'animation_zoom' => 'Zoom',
        'animation_none' => 'Aucun',
        'branding' => 'Image de marque de l\'écran de démarrage',
        'branding_description' => 'Ajoutez un logo, un titre, un sous-titre et un style de texte à votre écran de démarrage',
        'show_logo' => 'Afficher le logo sur l\'écran de démarrage',
        'logo_image' => 'Image du logo',
        'logo_image_help' => 'PNG avec transparence recommandé (MAX. 2 Mo)',
        'delete_logo' => 'Supprimer le logo',
        'logo_size' => 'Taille du logo :',
        'logo_size_small' => 'Petit (60dp)',
        'logo_size_medium' => 'Moyen (150dp)',
        'logo_size_large' => 'Grand (240dp)',
        'logo_size_help' => 'Ajustez la taille du logo pour une apparence optimale',
        'title' => 'Titre',
        'title_placeholder' => 'Mon super app',
        'subtitle' => 'Sous-titre',
        'subtitle_placeholder' => 'Bienvenue dans la meilleure application',
        'text_theme' => 'Thème du texte',
        'text_theme_light' => 'Clair (Texte blanc)',
        'text_theme_dark' => 'Sombre (Texte noir)',
    ],

    // Paramètres du tiroir
    'drawer' => [
        'appearance' => 'Apparence du tiroir',
        'appearance_description' => 'Personnalisez l\'arrière-plan et le style visuel de votre tiroir de navigation',
        'drawer_mode' => 'Mode du tiroir',
        'drawer_mode_help' => 'Choisissez comment l\'arrière-plan du tiroir doit apparaître',
        'mode_default' => 'Par défaut (Couleur du thème)',
        'mode_color' => 'Couleur personnalisée',
        'mode_image' => 'Image d\'arrière-plan',
        'background_color' => 'Couleur d\'arrière-plan',
        'background_color_help' => 'Couleur d\'arrière-plan personnalisée pour le tiroir',
        'background_image' => 'Image d\'arrière-plan',
        'background_image_help' => 'PNG uniquement (MAX. 2 Mo). Recommandé : 1080x1920px',
        'delete_background_image' => 'Supprimer l\'image d\'arrière-plan',
        'branding' => 'Image de marque du tiroir',
        'branding_description' => 'Ajoutez un logo, un titre et personnalisez l\'apparence du texte dans l\'en-tête du tiroir',
        'show_logo' => 'Afficher le logo dans le tiroir',
        'show_logo_help' => 'Afficher un logo dans l\'en-tête du tiroir',
        'logo_light' => 'Logo du tiroir (Mode clair)',
        'logo_light_help' => 'PNG avec transparence requis (MAX. 2 Mo) - Affiché lorsque l\'application est en thème clair',
        'delete_light_logo' => 'Supprimer le logo clair',
        'logo_dark' => 'Logo du tiroir (Mode sombre)',
        'logo_dark_help' => 'PNG avec transparence requis (MAX. 2 Mo) - Affiché lorsque l\'application est en thème sombre',
        'delete_dark_logo' => 'Supprimer le logo sombre',
        'logo_size' => 'Taille du logo :',
        'logo_size_small' => 'Petit (40dp)',
        'logo_size_medium' => 'Moyen (120dp)',
        'logo_size_large' => 'Grand (200dp)',
        'logo_size_help' => 'Ajustez la taille du logo pour une apparence optimale',
        'drawer_title' => 'Titre du tiroir',
        'drawer_title_placeholder' => 'Mon app',
        'drawer_title_help' => 'Titre affiché dans l\'en-tête du tiroir',
        'drawer_subtitle' => 'Sous-titre du tiroir',
        'drawer_subtitle_placeholder' => 'Bienvenue dans mon application',
        'drawer_subtitle_help' => 'Sous-titre ou slogan affiché sous le titre',
        'text_theme' => 'Thème du texte',
        'text_theme_help' => 'Couleur du texte pour l\'en-tête et les éléments du menu du tiroir',
        'text_theme_light' => 'Clair (Texte blanc)',
        'text_theme_dark' => 'Sombre (Texte noir)',
        'item_colors' => 'Couleurs des éléments du tiroir',
        'item_colors_description' => 'Personnalisez les couleurs des icônes et du texte des éléments du menu du tiroir',
        'item_icon_colors' => 'Couleurs des icônes des éléments du tiroir',
        'item_icon_colors_help' => 'Couleur des icônes et du texte des éléments inactifs du tiroir en mode clair et sombre',
        'active_item_colors' => 'Couleurs de l\'élément actif',
        'active_item_colors_help' => 'Couleur de l\'élément du tiroir sélectionné/actif en mode clair et sombre',
        'light_mode' => 'Mode clair',
        'dark_mode' => 'Mode sombre',
    ],

    // Paramètres de navigation
    'navigation' => [
        'bottom_nav_bar' => 'Barre de navigation inférieure',
        'bottom_nav_bar_description' => 'Configurez les éléments des onglets de navigation inférieurs (max 8 éléments)',
        'add_item' => '+ Ajouter un élément',
        'no_navigation_items' => 'Aucun élément de navigation configuré',
        'add_first_navigation_item' => 'Ajoutez votre premier élément de navigation',
        'home_tab_badge' => 'Onglet Accueil - Synchronisé avec l\'URL principale',
        'home_item_badge' => 'Élément Accueil - Synchronisé avec l\'URL principale',
        'label' => 'Libellé',
        'label_placeholder_home' => 'Accueil',
        'label_placeholder_about' => 'À propos',
        'action_type' => 'Type d\'action',
        'action_internal' => 'Lien interne',
        'action_external' => 'Lien externe',
        'action_hosted_page' => 'Page hébergée',
        'action_share' => 'Partager',
        'action_email' => 'Envoyer un e-mail',
        'action_call' => 'Passer un appel',
        'url' => 'URL',
        'email_address' => 'Adresse e-mail',
        'phone_number' => 'Numéro de téléphone',
        'hosted_page' => 'Page hébergée',
        'select_page' => 'Sélectionner une page',
        'synced_from_general' => 'Automatiquement synchronisé depuis les paramètres généraux',
        'icon' => 'Icône',
        'select_icon' => 'Sélectionner une icône',
        'search_icons' => 'Rechercher des icônes...',
        'home_tab_cannot_delete' => 'L\'onglet Accueil ne peut pas être supprimé',
        'home_item_cannot_delete' => 'L\'élément Accueil ne peut pas être supprimé',
        'max_navigation_items' => 'Maximum de 8 éléments de navigation atteint (hors onglet Accueil)',
        'app_bar_buttons' => 'Boutons de la barre d\'application',
        'app_bar_buttons_description' => 'Ajoutez des boutons d\'action en haut à droite de la barre d\'application (max 3 boutons)',
        'add_button' => '+ Ajouter un bouton',
        'no_app_bar_buttons' => 'Aucun bouton de barre d\'application configuré',
        'add_first_app_bar_button' => 'Ajoutez votre premier bouton de barre d\'application',
        'max_app_bar_buttons' => 'Maximum de 3 boutons de barre d\'application atteint',
        'drawer_menu_items' => 'Éléments du menu du tiroir',
        'drawer_menu_items_description' => 'Configurez les éléments du menu du tiroir de navigation (1 accueil + jusqu\'à 9 éléments supplémentaires)',
        'no_drawer_items' => 'Aucun élément de menu du tiroir configuré',
        'add_first_drawer_item' => 'Ajoutez votre premier élément de menu du tiroir',
        'max_drawer_items' => 'Maximum de 9 éléments supplémentaires atteint (10 au total incluant l\'élément accueil)',
        'behavior_settings' => 'Paramètres de comportement',
        'behavior_settings_description' => 'Configurez les interactions utilisateur',
        'pull_to_refresh' => 'Tirer pour actualiser',
        'pull_to_refresh_description' => 'Permettre aux utilisateurs d\'actualiser le contenu en tirant vers le bas',
        'swipe_navigation' => 'Navigation par balayage',
        'swipe_navigation_description' => 'Permettre aux utilisateurs de revenir en arrière en balayant depuis le bord',
        'swipe_navigation_disabled' => 'Désactivé pour les mises en page avec tiroir pour éviter les conflits de gestes',
        'preserve_tab_state' => 'Conserver l\'état des onglets',
        'preserve_tab_state_description' => 'Garder la page actuelle lors du changement d\'onglets/éléments du tiroir',
    ],

    // Barre latérale
    'sidebar' => [
        'app_settings' => 'Paramètres de l\'application',
        'general' => 'Général',
        'design' => 'Design',
        'icon' => 'Icône',
        'splashscreen' => 'Écran de démarrage',
        'navigation' => 'Navigation',
        'drawer' => 'Tiroir',
        'webview' => 'WebView',
        'permissions' => 'Permissions',
        'custom_code' => 'Code personnalisé',
        'hosted_pages' => 'Pages hébergées',
        'notifications' => 'Notifications',
        'deployment' => 'Déploiement',
        'builds' => 'Compilations',
        'signing' => 'Signature',
        'back_to_apps' => 'Retour aux applications',
    ],

    // Paramètres WebView
    'webview_user_agent_title' => 'Agent utilisateur',
    'webview_user_agent_description' => 'Personnalisez la chaîne d\'agent utilisateur du navigateur',
    'webview_custom_user_agent' => 'Agent utilisateur personnalisé',
    'webview_user_agent_placeholder' => 'Laissez vide pour utiliser l\'agent utilisateur WebView Android par défaut',
    'webview_user_agent_helper' => 'Optionnel. Remplacez l\'agent utilisateur par défaut envoyé à votre site web.',
    'webview_features_title' => 'Fonctionnalités WebView',
    'webview_features_description' => 'Configurez les capacités et le comportement du navigateur',
    'webview_enable_javascript' => 'Activer JavaScript',
    'webview_enable_javascript_description' => 'Autoriser l\'exécution de JavaScript dans la WebView',
    'webview_enable_dom_storage' => 'Activer le stockage DOM',
    'webview_enable_dom_storage_description' => 'Autoriser les API localStorage et sessionStorage',
    'webview_enable_zoom_controls' => 'Activer les contrôles de zoom',
    'webview_enable_zoom_controls_description' => 'Autoriser le zoom par pincement et les contrôles de zoom',
    'webview_enable_cache' => 'Activer le cache',
    'webview_enable_cache_description' => 'Mettre en cache le contenu web pour un chargement plus rapide',

    // Paramètres des permissions
    'permissions_location_title' => 'Permission de localisation',
    'permissions_location_description' => 'Accéder au GPS de l\'appareil pour les fonctionnalités basées sur la localisation',
    'permissions_enable_location' => 'Activer l\'accès à la localisation',
    'permissions_location_helper' => 'Requis pour les cartes, le contenu basé sur la localisation et les fonctionnalités de géorepérage.',
    'permissions_show_code_example' => 'Afficher l\'exemple de code',
    'permissions_hide_code_example' => 'Masquer l\'exemple de code',
    'permissions_javascript_example' => 'Exemple JavaScript :',
    'permissions_camera_title' => 'Permission de la caméra',
    'permissions_camera_description' => 'Accéder à la caméra de l\'appareil pour les photos et vidéos',
    'permissions_enable_camera' => 'Activer l\'accès à la caméra',
    'permissions_camera_helper' => 'Requis pour prendre des photos, scanner des QR codes et les appels vidéo.',
    'permissions_storage_title' => 'Permission de stockage',
    'permissions_storage_description' => 'Accéder au stockage de l\'appareil pour les téléversements et téléchargements de fichiers',
    'permissions_enable_storage' => 'Activer l\'accès au stockage',
    'permissions_storage_helper' => 'Requis pour les téléversements de fichiers, le sélecteur d\'images et le téléchargement de fichiers.',
    'permissions_microphone_title' => 'Permission du microphone',
    'permissions_microphone_description' => 'Accéder au microphone de l\'appareil pour l\'enregistrement audio',
    'permissions_enable_microphone' => 'Activer l\'accès au microphone',
    'permissions_microphone_helper' => 'Requis pour l\'enregistrement vocal, les appels audio et la reconnaissance vocale.',
    'permissions_contacts_title' => 'Permission des contacts',
    'permissions_contacts_description' => 'Accéder aux contacts de l\'appareil pour les fonctionnalités sociales',
    'permissions_enable_contacts' => 'Activer l\'accès aux contacts',
    'permissions_contacts_helper' => 'Requis pour le sélecteur de contacts, les fonctionnalités d\'invitation et les intégrations sociales.',
    'permissions_vibrate_title' => 'Permission de vibration',
    'permissions_vibrate_description' => 'Accéder au moteur de vibration de l\'appareil pour le retour haptique',
    'permissions_enable_vibrate' => 'Activer la vibration',
    'permissions_vibrate_helper' => 'Requis pour le retour haptique et les vibrations de notification.',

    // Paramètres du code personnalisé
    'custom_code_access_required_title' => 'Mise à niveau requise',
    'custom_code_access_required_description' => 'Votre forfait actuel n\'inclut pas l\'injection de code personnalisé. Mettez à niveau pour accéder à cette fonctionnalité et ajouter du CSS et JavaScript personnalisés à votre application.',
    'custom_code_upgrade_plan' => 'Mettez à niveau votre forfait',
    'custom_code_enable_feature' => 'pour activer cette fonctionnalité.',
    'custom_code_css_title' => 'CSS personnalisé',
    'custom_code_css_description' => 'Ajoutez des styles personnalisés pour personnaliser l\'apparence de votre application',
    'custom_code_css_label' => 'Code CSS',
    'custom_code_css_helper' => 'Maximum 100 Ko. Le CSS sera injecté dans chaque page.',
    'custom_code_js_title' => 'JavaScript personnalisé',
    'custom_code_js_description' => 'Ajoutez des scripts personnalisés pour des fonctionnalités étendues',
    'custom_code_js_label' => 'Code JavaScript',
    'custom_code_js_helper' => 'Maximum 100 Ko. Le JavaScript sera exécuté dans la WebView.',

    // Paramètres des notifications
    'notifications_title' => 'Notifications',
    'notifications_description' => 'Configurez Firebase Cloud Messaging (FCM) pour les notifications',
    'notifications_enable' => 'Activer les notifications',
    'notifications_firebase_service_account' => 'Compte de service Firebase',
    'notifications_firebase_service_account_description' => 'Utilisé par le serveur pour envoyer des notifications via l\'API FCM',
    'notifications_firebase_help_text' => 'Fichier JSON (MAX. 2 Mo)',
    'notifications_delete_firebase_credentials' => 'Supprimer les identifiants Firebase',
    'notifications_delete_firebase_credentials_confirm' => 'Êtes-vous sûr de vouloir supprimer le fichier d\'identifiants Firebase ?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Requis pour la configuration de l\'application Android',
    'notifications_google_services_help_text' => 'Fichier JSON (MAX. 1 Mo)',
    'notifications_delete_google_services' => 'Supprimer le fichier Google Services',
    'notifications_delete_google_services_confirm' => 'Êtes-vous sûr de vouloir supprimer le fichier Google Services ?',

    // Paramètres des clés de signature
    'signing_keys' => [
        'android_keystores' => 'Keystores Android',
        'generate_new' => 'Générer nouveau',
        'upload_existing' => 'Téléverser existant',
        'default_badge' => 'Par défaut',
        'alias' => 'Alias',
        'alias_placeholder' => 'mon-alias-cle',
        'auto_generated' => 'Généré automatiquement',
        'created' => 'Créé',
        'set_as_default' => 'Définir par défaut',
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'no_keystores' => 'Pas encore de keystores Android. Générez une nouvelle clé ou téléversez-en une existante.',
        'upload_signing_key' => 'Téléverser une clé de signature',
        'android_keystore_upload' => 'Téléversement du keystore Android',
        'keystore_name' => 'Nom du keystore',
        'keystore_name_placeholder' => 'Mon keystore de production',
        'keystore_file' => 'Fichier keystore',
        'keystore_file_help' => 'Fichier .jks, .keystore ou .ks (Max 5 Mo)',
        'upload_custom_key' => 'Téléverser une clé personnalisée',
        'upload_custom_key_help' => 'Décochez si vous utilisez un keystore de debug généré automatiquement',
        'password' => 'Mot de passe',
        'password_placeholder' => '••••••••',
        'password_help' => 'Utilisé pour l\'accès au keystore et à la clé',
        'cancel' => 'Annuler',
        'upload' => 'Téléverser',
        'edit_keystore' => 'Modifier le keystore',
        'update_password' => 'Mettre à jour le mot de passe',
        'save' => 'Enregistrer',
        'delete_keystore' => 'Supprimer le keystore',
        'delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer',
        'action_cannot_be_undone' => 'Cette action est irréversible.',

        // Modal de génération de keystore
        'generate_signing_key' => 'Générer une clé de signature',
        'generate_android_keystore' => 'Générer un keystore Android',
        'generate_keystore_description' => 'Un nouveau keystore JKS sera généré de manière sécurisée sur le serveur de compilation',
        'keystore_name_generate_placeholder' => 'Clé de production de mon app',
        'key_alias' => 'Alias de la clé',
        'key_alias_placeholder' => 'ma-cle-app',
        'key_alias_help' => 'Doit commencer par une lettre. Lettres, chiffres, tirets et underscores autorisés.',
        'password_settings' => 'Paramètres du mot de passe',
        'keystore_password' => 'Mot de passe du keystore',
        'min_characters_placeholder' => 'Min. 6 caractères',
        'use_same_password' => 'Utiliser le même mot de passe pour la clé et le keystore',
        'key_password' => 'Mot de passe de la clé',
        'validity_period' => 'Période de validité',
        'years_10' => '10 ans',
        'years_15' => '15 ans',
        'years_20' => '20 ans',
        'years_25_recommended' => '25 ans (Recommandé)',
        'years_30' => '30 ans',
        'validity_help' => 'Google Play exige au moins 25 ans de validité pour les nouvelles applications',
        'certificate_details' => 'Détails du certificat (Optionnel)',
        'common_name' => 'Nom commun (CN)',
        'common_name_placeholder' => 'Nom de votre application ou organisation',
        'organization' => 'Organisation (O)',
        'organization_placeholder' => 'Nom de l\'entreprise',
        'organizational_unit' => 'Unité organisationnelle (OU)',
        'organizational_unit_placeholder' => 'Applications mobiles',
        'city' => 'Ville (L)',
        'city_placeholder' => 'Paris',
        'state' => 'État/Région (ST)',
        'state_placeholder' => 'Île-de-France',
        'country' => 'Pays (C)',
        'country_placeholder' => 'FR',
        'save_password_warning' => 'Important : Conservez votre mot de passe en lieu sûr !',
        'save_password_description' => 'Le keystore sera chiffré et stocké. Vous aurez besoin du mot de passe pour les futures compilations. Il n\'y a aucun moyen de récupérer un mot de passe perdu.',
        'generating' => 'Génération...',
        'generate_keystore' => 'Générer le keystore',
    ],

    // Paramètres des pages hébergées
    'hosted_pages' => [
        'access_required' => 'Accès aux pages hébergées requis',
        'upgrade_description' => 'Votre forfait actuel n\'inclut pas les pages hébergées. Mettez à niveau votre forfait pour créer des pages personnalisées hébergées par nous.',
        'upgrade_plan' => 'Mettez à niveau votre forfait',
        'upgrade_suffix' => 'pour activer cette fonctionnalité.',
        'table_page' => 'Page',
        'table_status' => 'Statut',
        'table_created' => 'Créé',
        'table_actions' => 'Actions',
        'status_published' => 'Publiée',
        'status_draft' => 'Brouillon',
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'no_pages' => 'Aucune page pour le moment',
        'no_pages_description' => 'Cliquez sur « Ajouter une page » pour créer votre première page hébergée.',
    ],

    // Modal de l'éditeur de page hébergée
    'hosted_page_editor' => [
        'create_page' => 'Créer une page',
        'edit_page' => 'Modifier la page',
        'title' => 'Titre',
        'title_placeholder' => 'Titre de la page',
        'slug' => 'Slug',
        'slug_placeholder' => 'slug-de-la-page',
        'start_from_template' => 'Partir d\'un modèle',
        'status' => 'Statut',
        'status_help' => 'Seules les pages publiées sont accessibles dans l\'application',
        'cancel' => 'Annuler',
        'save_changes' => 'Enregistrer les modifications',
    ],

    // Paramètres spécifiques à WordPress
    'wordpress' => [
        // Paramètres généraux
        'app_name_placeholder' => 'Mon app WordPress',
        'wordpress_site_url' => 'URL du site WordPress',
        'wordpress_site_url_placeholder' => 'https://monblog.wordpress.com',
        'wordpress_site_url_help' => 'Entrez l\'URL de votre site WordPress.com (ex. monblog.wordpress.com)',
        'app_id_placeholder' => 'com.exemple.wordpress',
        'package_name_help' => 'Identifiant unique au format domaine inversé (ex. com.entreprise.wordpress). Ne peut pas être modifié après création.',

        // Paramètres de design
        'post_list_style' => 'Style de la liste des articles',
        'style_list' => 'Liste',
        'style_grid' => 'Grille',
        'style_magazine' => 'Magazine',
        'post_list_style_help' => 'Comment les articles sont affichés dans l\'application',
        'progress_indicator_help' => 'Style de l\'indicateur de chargement lors de la récupération des articles',
        'show_app_bar_title' => 'Afficher le nom de l\'application dans la barre d\'application',
        'show_app_bar_title_help' => 'Afficher le nom de votre application dans la barre supérieure',
        'nav_tab_icon_colors_help' => 'Couleur des icônes d\'onglets inactifs',
        'active_tab_colors_help' => 'Couleur de l\'onglet sélectionné',
        'theme_color_help' => 'Couleur principale utilisée dans toute votre application (bleu WordPress : #21759B)',
        'dynamic_colors_help' => 'Lorsqu\'activé, votre application adaptera les couleurs du fond d\'écran de l\'utilisateur sur les appareils Android 12+.',
        'layout_list_only' => 'Liste uniquement',

        // Paramètres de l'écran de démarrage
        'splashscreen_title_placeholder' => 'Mon app WordPress',
        'splashscreen_subtitle_placeholder' => 'Bienvenue dans la meilleure application de blog',

        // Barre latérale
        'content' => 'Contenu',
        'features' => 'Fonctionnalités',

        // Paramètres du tiroir
        'drawer_appearance_description' => 'Personnalisez l\'arrière-plan du tiroir de navigation',
        'drawer_branding_description' => 'Logo, titre et style du texte',
        'logo_light_mode' => 'Logo (Mode clair)',
        'logo_dark_mode' => 'Logo (Mode sombre)',
        'png_transparency_help' => 'PNG avec transparence (MAX. 2 Mo)',
        'delete_background' => 'Supprimer l\'arrière-plan',
        'drawer_title_placeholder' => 'Mon app WordPress',
        'drawer_subtitle_placeholder' => 'Votre slogan ici',
        'item_colors_description' => 'Couleurs des icônes et du texte des éléments du menu',
        'inactive_item_colors' => 'Couleurs des éléments inactifs',

        // Paramètres de navigation
        'bottom_nav_tabs' => 'Onglets de navigation inférieure',
        'bottom_nav_tabs_description' => 'Configurez les éléments de navigation inférieure (max 8 + accueil)',
        'add_tab' => '+ Ajouter un onglet',
        'home_tab_shows_all_posts' => 'Onglet Accueil - Affiche tous les articles',
        'home_item_shows_all_posts' => 'Élément Accueil - Affiche tous les articles',
        'tab_name_placeholder' => 'Nom de l\'onglet',
        'menu_item_placeholder' => 'Élément de menu',
        'action_category' => 'Catégorie',
        'action_tag' => 'Étiquette',
        'action_search' => 'Recherche',
        'action_bookmarks' => 'Favoris',
        'action_share' => 'Partager',
        'category_slug' => 'Slug de catégorie',
        'tag_slug' => 'Slug d\'étiquette',
        'category_slug_placeholder' => 'technologie',
        'tag_slug_placeholder' => 'en-vedette',
        'app_bar_buttons_description' => 'Boutons d\'action en haut à droite (max 3)',
        'no_app_bar_buttons_description' => 'Aucun bouton de barre d\'application configuré. Ajoutez recherche, partage ou d\'autres actions rapides.',
        'search_placeholder' => 'Rechercher',
        'drawer_menu_items_description' => 'Éléments du menu du tiroir de navigation (1 accueil + jusqu\'à 9 éléments)',
        'swipe_navigation_description' => 'Revenir en arrière en balayant depuis le bord',
        'preserve_tab_state_description' => 'Conserver la position de défilement lors du changement d\'onglets',

        // Paramètres de contenu
        'post_display' => 'Affichage des articles',
        'post_display_description' => 'Configurez comment les articles sont affichés dans votre application',
        'posts_per_page' => 'Articles par page',
        'posts_per_page_help' => 'Nombre d\'articles à charger à la fois (1-50)',
        'excerpt_length' => 'Longueur de l\'extrait (caractères)',
        'excerpt_length_help' => 'Nombre maximum de caractères affichés dans les extraits d\'articles (50-500)',
        'post_metadata' => 'Métadonnées des articles',
        'post_metadata_description' => 'Choisissez quelles informations afficher avec chaque article',
        'show_featured_image' => 'Afficher l\'image mise en avant',
        'show_featured_image_help' => 'Afficher l\'image mise en avant/miniature de l\'article',
        'show_excerpt' => 'Afficher l\'extrait de l\'article',
        'show_excerpt_help' => 'Afficher un aperçu du contenu de l\'article',
        'show_author' => 'Afficher le nom de l\'auteur',
        'show_author_help' => 'Afficher l\'auteur qui a écrit l\'article',
        'show_date' => 'Afficher la date de publication',
        'show_date_help' => 'Afficher quand l\'article a été publié',
        'show_categories' => 'Afficher les catégories',
        'show_categories_help' => 'Afficher les catégories assignées à l\'article',
        'show_reading_time' => 'Afficher le temps de lecture estimé',
        'show_reading_time_help' => 'Afficher combien de temps il faut pour lire l\'article',

        // Paramètres des fonctionnalités
        'core_features' => 'Fonctionnalités principales',
        'core_features_description' => 'Activer ou désactiver les fonctionnalités de l\'application',
        'enable_search' => 'Activer la recherche',
        'enable_search_help' => 'Permettre aux utilisateurs de rechercher des articles dans votre application',
        'enable_comments' => 'Activer les commentaires',
        'enable_comments_help' => 'Permettre aux utilisateurs de voir et publier des commentaires sur les articles',
        'enable_bookmarks' => 'Activer les favoris',
        'enable_bookmarks_help' => 'Permettre aux utilisateurs d\'enregistrer des articles pour une lecture ultérieure',
        'enable_share' => 'Activer le partage',
        'enable_share_help' => 'Permettre aux utilisateurs de partager des articles via d\'autres applications',
        'advanced_features' => 'Fonctionnalités avancées',
        'advanced_features_description' => 'Fonctionnalités supplémentaires pour une meilleure expérience utilisateur',
        'enable_offline_reading' => 'Activer la lecture hors ligne',
        'enable_offline_reading_help' => 'Mettre en cache les articles pour une lecture sans connexion internet',
        'enable_user_auth' => 'Activer l\'authentification utilisateur',
        'enable_user_auth_help' => 'Permettre aux utilisateurs de se connecter avec leur compte WordPress.com',
        'enable_push_notifications' => 'Activer les notifications push',
        'enable_push_notifications_help' => 'Envoyer des notifications lorsque de nouveaux articles sont publiés',
    ],

    // Compilations
    'builds' => [
        // Tableau des compilations
        'search_placeholder' => 'Rechercher des compilations...',
        'filter' => 'Filtrer',
        'platform_filter' => 'Plateforme',
        'status_filter' => 'Statut',
        'android' => 'Android',
        'completed' => 'Terminée',
        'building' => 'En cours',
        'failed' => 'Échouée',
        'pending' => 'En attente',
        'table_platform' => 'Plateforme',
        'table_build_info' => 'Info compilation',
        'table_created' => 'Créé',
        'table_actions' => 'Actions',
        'release' => 'Release',
        'debug' => 'Debug',
        'download' => 'Télécharger',
        'preview' => 'Aperçu',
        'logs' => 'Journaux',
        'delete' => 'Supprimer',
        'no_builds' => 'Aucune compilation trouvée',

        // Modal de compilation
        'create_new_build' => 'Créer une nouvelle compilation',
        'platform_label' => 'Plateforme',
        'build_costs_credit' => 'La compilation coûte :count crédit|La compilation coûte :count crédits',
        'build_type_label' => 'Type de compilation',
        'for_testing' => 'Pour les tests',
        'for_production' => 'Pour la production',
        'output_format_label' => 'Format de sortie',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'Pour les tests/installation manuelle',
        'for_google_play_store' => 'Pour Google Play Store',
        'builder_label' => 'Compilateur',
        'auto_select_recommended' => 'Sélection auto (recommandé)',
        'auto_select_help' => 'Laissez sur « Sélection auto » pour utiliser le compilateur le moins occupé, ou choisissez un compilateur spécifique.',
        'no_builders_available' => 'Aucun compilateur disponible !',
        'no_builders_help' => 'Votre forfait n\'a accès à aucun compilateur. Veuillez contacter le support ou mettre à niveau votre forfait.',
        'signing_key_label' => 'Clé de signature',
        'select_keystore' => 'Sélectionner un keystore',
        'no_keystores_available' => 'Aucun keystore disponible.',
        'upload_in_signing_section' => 'Téléversez-en un dans la section Signature',
        'signing_key_required' => 'Clé de signature requise !',
        'version_name_label' => 'Nom de version',
        'version_name_help' => 'Format : X.Y ou X.Y.Z (ex. 1.0 ou 1.0.0). Auto-incrémenté pour chaque plateforme.',
        'build_number_label' => 'Numéro de compilation',
        'next_build_number' => 'Prochain numéro de compilation',
        'build_number_auto_increment' => 'Le numéro de compilation s\'incrémente automatiquement à chaque compilation',
        'build_cost_info' => 'Cette compilation coûtera :count crédit|Cette compilation coûtera :count crédits',
        'build_email_notification' => 'Vous recevrez un e-mail lorsque la compilation sera prête à télécharger.',
        'cancel' => 'Annuler',
        'start_build' => 'Démarrer la compilation',
        'credit' => 'crédit',
        'credits' => 'crédits',
        'builder_info' => 'Compilateur :',

        // Modal des journaux de compilation
        'build_logs' => 'Journaux de compilation',
        'duration' => 'Durée :',
        'no_logs_available' => 'Aucun journal disponible pour cette compilation',
        'error' => 'Erreur :',
        'close' => 'Fermer',
        'download_build' => 'Télécharger la compilation',

        // Modal de téléchargement de compilation
        'download_build_title' => 'Télécharger la compilation',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'Ceci est un fichier AAB qui ne peut pas être installé directement sur les appareils. Les fichiers AAB sont conçus pour être téléversés sur la Console Google Play, où Google génèrera des APK optimisés pour les utilisateurs.',
        'scan_with_android' => 'Scannez avec votre appareil Android',
        'qr_unavailable' => 'QR code non disponible',
        'download_options' => 'Options de téléchargement',
        'download_options_description' => 'Scannez le QR code avec votre appareil mobile ou utilisez le lien de téléchargement direct ci-dessous.',
        'download_format' => 'Télécharger :format',
        'installation_note' => 'Installation :',
        'installation_help' => 'Vous devrez peut-être activer « Installer depuis des sources inconnues » dans les paramètres Android.',
        'download_aab_file' => 'Télécharger le fichier AAB',
        'upload_to_play_console' => 'Téléversez ce fichier sur la Console Google Play pour publier votre application.',
        'next_steps' => 'Prochaines étapes :',
        'next_steps_help' => 'Téléversez ce fichier AAB sur la Console Google Play sous Release > Production/Test. Google génèrera automatiquement des APK optimisés pour vos utilisateurs.',

        // Modal de suppression de compilation
        'delete_build' => 'Supprimer la compilation',
        'delete_confirmation' => 'Êtes-vous sûr de vouloir supprimer la',
        'build_suffix' => 'compilation ?',
        'action_cannot_be_undone' => 'Cette action est irréversible.',
    ],

    // Panneau d'aperçu de l'application
    'preview' => [
        'no_build_selected' => 'Aucune compilation sélectionnée',
        'select_build_help' => 'Sélectionnez une compilation terminée dans l\'onglet Compilations pour la prévisualiser ici',
    ],

    // Formulaire de création d'application
    'creation' => [
        'website_url' => 'URL du site web',
        'app_id' => 'ID APPLICATION',
        'app_id_tooltip' => 'Identifiant de paquet unique (ne peut pas être modifié après création)',
        'auto_generate_package' => 'Générer automatiquement à partir du nom de l\'application',
        'package_name_help' => 'Identifiant unique au format domaine inversé (ex. com.entreprise.app). Ne peut pas être modifié après création.',
        'theme_color' => 'Couleur du thème',
        'theme_color_help' => 'Couleur principale utilisée dans toute votre application. Les couleurs du texte utiliseront le noir/blanc par défaut et pourront être personnalisées ultérieurement.',
        'layout_template' => 'Modèle de mise en page',
        'layout_app_bar_drawer' => 'Barre d\'application + Tiroir',
        'layout_app_bar_tabs' => 'Barre d\'application + Onglets de navigation',
        'layout_app_bar' => 'Barre d\'application',
        'layout_blank' => 'Vide',
        'layout_help' => 'Choisissez la structure de navigation pour votre application',
    ],

    // Modales de suppression
    'modals' => [
        'cancel' => 'Annuler',
        'delete' => 'Supprimer',
        'action_cannot_be_undone' => 'Cette action est irréversible.',
        'delete_build' => 'Supprimer la compilation',
        'delete_build_confirmation' => 'Êtes-vous sûr de vouloir supprimer la',
        'build_suffix' => 'compilation ?',
        'delete_app_icon' => 'Supprimer l\'icône de l\'application',
        'delete_icon_confirmation' => 'Êtes-vous sûr de vouloir supprimer l\'icône de',
        'delete_keystore' => 'Supprimer le keystore',
        'delete_keystore_confirmation' => 'Êtes-vous sûr de vouloir supprimer',
        'delete_splashscreen_background' => 'Supprimer l\'arrière-plan de l\'écran de démarrage',
        'delete_splashscreen_background_confirmation' => 'Êtes-vous sûr de vouloir supprimer l\'image d\'arrière-plan de l\'écran de démarrage pour',
        'delete_splashscreen_logo' => 'Supprimer le logo de l\'écran de démarrage',
        'delete_splashscreen_logo_confirmation' => 'Êtes-vous sûr de vouloir supprimer le logo de l\'écran de démarrage pour',
        'delete_drawer_background' => 'Supprimer l\'arrière-plan du tiroir',
        'delete_drawer_background_confirmation' => 'Êtes-vous sûr de vouloir supprimer l\'image d\'arrière-plan du tiroir pour',
        'delete_dark_mode_logo' => 'Supprimer le logo mode sombre',
        'delete_dark_mode_logo_confirmation' => 'Êtes-vous sûr de vouloir supprimer le logo mode sombre du tiroir pour',
        'delete_light_mode_logo' => 'Supprimer le logo mode clair',
        'delete_light_mode_logo_confirmation' => 'Êtes-vous sûr de vouloir supprimer le logo mode clair du tiroir pour',
        'delete_page' => 'Supprimer la page',
        'delete_page_confirmation' => 'Êtes-vous sûr de vouloir supprimer',
        'delete_page_warning' => 'Cette action est irréversible. Si cette page est utilisée dans votre navigation, elle ne sera plus accessible.',
    ],

    // Paramètres des notifications WordPress
    'notifications_wp' => [
        'title' => 'Notifications push',
        'description' => 'Configurez Firebase Cloud Messaging pour les notifications push',
        'enable_label' => 'Activer les notifications push',
        'enable_help' => 'Envoyer des notifications lorsque de nouveaux articles sont publiés',
        'firebase_required_title' => 'Configuration Firebase requise',
        'firebase_required_description' => 'Téléversez les deux fichiers de configuration ci-dessous pour activer les notifications push dans votre application.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'Fichier téléversé',
        'google_services_configured' => 'google-services.json est configuré',
        'delete' => 'Supprimer',
        'delete_file_confirm' => 'Êtes-vous sûr de vouloir supprimer ce fichier ?',
        'upload_google_services' => 'Téléverser google-services.json',
        'google_services_help' => 'Téléchargez depuis la Console Firebase (MAX. 1 Mo)',
        'google_services_instructions' => 'Téléchargez depuis Console Firebase > Paramètres du projet > Vos applications > Application Android',
        'firebase_service_account_label' => 'Compte de service Firebase (pour l\'envoi des notifications)',
        'credentials_configured' => 'Identifiants configurés',
        'service_account_stored' => 'Le compte de service est stocké de manière sécurisée',
        'delete_credentials_confirm' => 'Êtes-vous sûr de vouloir supprimer ces identifiants ?',
        'upload_service_account' => 'Téléverser le JSON du compte de service',
        'service_account_help' => 'Téléchargez depuis la Console Firebase (MAX. 2 Mo)',
        'service_account_instructions' => 'Téléchargez depuis Console Firebase > Paramètres du projet > Comptes de service > Générer une nouvelle clé privée',
        'setup_title' => 'Comment configurer Firebase :',
        'setup_step_1' => 'Allez sur',
        'setup_step_2' => 'Créez un projet ou sélectionnez-en un existant',
        'setup_step_3' => 'Ajoutez une application Android avec votre nom de paquet :',
        'setup_step_4' => 'Téléchargez',
        'setup_step_4_suffix' => 'et téléversez-le ci-dessus',
        'setup_step_5' => 'Allez dans Paramètres du projet > Comptes de service',
        'setup_step_6' => 'Générez une nouvelle clé privée et téléversez-la ci-dessus',
    ],

    // Messages toast - Paramètres
    'toast' => [
        // Succès/erreur générale
        'settings_saved' => 'Paramètres :section enregistrés avec succès !',
        'settings_save_failed' => 'Échec de l\'enregistrement des paramètres. Veuillez réessayer.',

        // Paramètres de design
        'design_saved' => 'Paramètres de design enregistrés avec succès !',

        // Paramètres de navigation
        'navigation_saved' => 'Paramètres de navigation enregistrés avec succès !',
        'home_tab_cannot_delete' => 'L\'onglet Accueil ne peut pas être supprimé. Il est requis pour la navigation.',
        'home_tab_cannot_move' => 'L\'onglet Accueil doit rester en première position et ne peut pas être déplacé.',
        'cannot_move_below_home' => 'Impossible de déplacer des éléments sous l\'onglet Accueil.',
        'home_item_cannot_delete' => 'L\'élément Accueil ne peut pas être supprimé. Il est requis pour la navigation.',
        'home_item_cannot_move' => 'L\'élément Accueil doit rester en première position et ne peut pas être déplacé.',
        'cannot_move_below_home_item' => 'Impossible de déplacer des éléments sous l\'élément Accueil.',

        // Code personnalisé
        'custom_code_saved' => 'Code personnalisé enregistré avec succès !',
        'custom_code_save_failed' => 'Échec de l\'enregistrement du code personnalisé. Veuillez réessayer.',
        'custom_code_no_access' => 'Votre forfait n\'inclut pas l\'accès au code personnalisé. Veuillez mettre à niveau votre forfait.',

        // Paramètres WebView
        'webview_saved' => 'Paramètres WebView enregistrés avec succès !',

        // Paramètres des permissions
        'permissions_saved' => 'Permissions enregistrées avec succès !',

        // Paramètres du tiroir
        'drawer_saved' => 'Paramètres du tiroir enregistrés avec succès !',

        // Paramètres généraux
        'general_saved' => 'Paramètres généraux enregistrés avec succès !',

        // Paramètres de l'écran de démarrage
        'splashscreen_saved' => 'Paramètres de l\'écran de démarrage enregistrés avec succès !',

        // Paramètres de l'icône
        'icon_uploaded' => 'Icône de l\'application téléversée avec succès !',
        'icon_upload_failed' => 'Échec du téléversement de l\'icône : :error',
        'icon_removed' => 'Icône de l\'application supprimée avec succès !',
        'icon_remove_failed' => 'Échec de la suppression de l\'icône. Veuillez réessayer.',

        // Modales de l'écran de démarrage
        'splashscreen_background_deleted' => 'Image d\'arrière-plan de l\'écran de démarrage supprimée avec succès !',
        'splashscreen_background_delete_failed' => 'Échec de la suppression de l\'image d\'arrière-plan. Veuillez réessayer.',
        'splashscreen_logo_deleted' => 'Logo de l\'écran de démarrage supprimé avec succès !',
        'splashscreen_logo_delete_failed' => 'Échec de la suppression du logo. Veuillez réessayer.',

        // Modales du tiroir
        'drawer_background_deleted' => 'Image d\'arrière-plan du tiroir supprimée avec succès !',
        'drawer_background_delete_failed' => 'Échec de la suppression de l\'image d\'arrière-plan. Veuillez réessayer.',
        'drawer_logo_deleted' => 'Logo du tiroir supprimé avec succès !',
        'drawer_logo_delete_failed' => 'Échec de la suppression du logo. Veuillez réessayer.',
        'drawer_logo_light_deleted' => 'Logo mode clair du tiroir supprimé avec succès !',
        'drawer_logo_dark_deleted' => 'Logo mode sombre du tiroir supprimé avec succès !',

        // Paramètres des notifications
        'notifications_saved' => 'Paramètres de notification enregistrés avec succès !',
        'firebase_credentials_deleted' => 'Identifiants Firebase supprimés avec succès !',
        'firebase_credentials_delete_failed' => 'Échec de la suppression des identifiants Firebase. Veuillez réessayer.',
        'google_services_deleted' => 'Fichier Google Services supprimé avec succès !',
        'google_services_delete_failed' => 'Échec de la suppression du fichier Google Services. Veuillez réessayer.',

        // Clés de signature
        'keystore_updated' => 'Keystore mis à jour avec succès !',
        'keystore_update_failed' => 'Échec de la mise à jour du keystore.',
        'keystore_load_failed' => 'Échec du chargement du keystore.',
        'keystore_deleted' => 'Keystore supprimé avec succès !',
        'keystore_delete_failed' => 'Échec de la suppression du keystore. Veuillez réessayer.',
        'keystore_uploaded' => 'Keystore téléversé avec succès !',
        'keystore_upload_failed' => 'Échec du téléversement de la clé de signature : :error',
        'keystore_generated' => 'Keystore généré avec succès !',
        'keystore_set_default' => 'Keystore par défaut mis à jour avec succès !',

        // Modal de compilation
        'build_no_builders_platform' => 'Aucun compilateur disponible pour la plateforme :platform. Veuillez contacter le support ou mettre à niveau votre forfait.',
        'build_no_subscription' => 'Vous avez besoin d\'un abonnement actif pour compiler des applications. Veuillez vous abonner à un forfait.',
        'build_no_builders_plan' => 'Aucun compilateur disponible pour votre forfait. Veuillez contacter le support ou mettre à niveau votre forfait.',
        'build_builder_not_available' => 'Le compilateur sélectionné n\'est pas disponible pour votre forfait.',
        'build_builder_unavailable' => 'Le compilateur sélectionné est actuellement indisponible.',
        'build_builder_no_platform' => 'Le compilateur sélectionné ne supporte pas la plateforme :platform.',
        'build_insufficient_credits' => 'Crédits de compilation insuffisants. Cette compilation nécessite :count crédit(s). Veuillez mettre à niveau votre forfait ou attendre la réinitialisation mensuelle.',
        'build_keystore_required' => 'Un keystore Android est requis pour les compilations Release. Veuillez sélectionner un keystore.',
        'build_keystore_invalid' => 'Keystore sélectionné invalide.',
        'build_already_in_progress' => 'Une compilation :platform est déjà en cours. Veuillez attendre qu\'elle soit terminée.',
        'build_queued' => 'Compilation :platform mise en file d\'attente avec succès ! Votre compilation sera traitée lorsqu\'un compilateur sera disponible. (:credits crédits restants)',
        'build_queued_on_builder' => 'Compilation :platform mise en file d\'attente avec succès sur :builder ! (:credits crédits restants)',
        'build_create_failed' => 'Échec de la création de la compilation : :error',
        'build_deleted' => 'Compilation supprimée avec succès !',
        'build_delete_failed' => 'Échec de la suppression de la compilation. Veuillez réessayer.',

        // Pages hébergées
        'hosted_page_saved' => 'Page enregistrée avec succès !',
        'hosted_page_save_failed' => 'Échec de l\'enregistrement de la page. Veuillez réessayer.',
        'hosted_page_deleted' => 'Page supprimée avec succès !',
        'hosted_page_delete_failed' => 'Échec de la suppression de la page. Veuillez réessayer.',
        'hosted_page_limit_reached' => 'Vous avez atteint le nombre maximum de pages hébergées pour votre forfait.',
        'hosted_page_no_access' => 'Votre forfait actuel n\'inclut pas les pages hébergées. Mettez à niveau votre forfait pour créer des pages personnalisées.',

        // Clés toast supplémentaires pour AndroidWordPress
        'features_saved' => 'Paramètres des fonctionnalités enregistrés avec succès !',
        'content_saved' => 'Paramètres de contenu enregistrés avec succès !',
        'storage_link_missing' => 'Lien de stockage introuvable. Exécutez : php artisan storage:link',
        'splashscreen_image_deleted' => 'Image d\'arrière-plan de l\'écran de démarrage supprimée avec succès !',
        'splashscreen_image_delete_failed' => 'Échec de la suppression de l\'image d\'arrière-plan. Veuillez réessayer.',
        'logo_delete_failed' => 'Échec de la suppression du logo. Veuillez réessayer.',
        'default_key_updated' => 'Clé de signature par défaut mise à jour avec succès !',
        'default_key_update_failed' => 'Échec de la mise à jour de la clé de signature par défaut.',
        'keystore_uploaded_default' => 'Keystore téléversé et défini par défaut !',
        'signing_key_upload_failed' => 'Échec du téléversement de la clé de signature : :error',
        'page_not_found' => 'Page introuvable.',
        'page_deleted' => 'Page supprimée avec succès !',
        'page_delete_failed' => 'Échec de la suppression de la page. Veuillez réessayer.',
        'page_updated' => 'Page mise à jour avec succès !',
        'page_created' => 'Page créée avec succès !',
        'page_save_failed' => 'Échec de l\'enregistrement de la page. Veuillez réessayer.',
        'page_limit_reached' => 'Vous avez atteint le maximum de :max pages pour votre forfait.',
        'hosted_pages_not_available' => 'Votre forfait n\'inclut pas les pages hébergées. Veuillez mettre à niveau votre forfait.',
        'unauthorized' => 'Action non autorisée.',
        'home_tab_required' => 'L\'onglet Accueil ne peut pas être supprimé. Il est requis pour la navigation.',
        'home_tab_first' => 'L\'onglet Accueil doit rester en première position.',
        'home_item_required' => 'L\'élément Accueil ne peut pas être supprimé.',
        'build_no_builders' => 'Aucun compilateur disponible pour la plateforme :platform. Veuillez contacter le support ou mettre à niveau votre forfait.',
        'build_no_plan_builders' => 'Aucun compilateur disponible pour votre forfait. Veuillez contacter le support ou mettre à niveau votre forfait.',
        'build_builder_platform_unsupported' => 'Le compilateur sélectionné ne supporte pas la plateforme :platform.',
        'build_insufficient_credits' => 'Crédits de compilation insuffisants. Cette compilation nécessite :credits crédit(s). Veuillez mettre à niveau votre forfait ou attendre la réinitialisation mensuelle.',
        'build_invalid_keystore' => 'Keystore sélectionné invalide.',
        'build_queued_no_builder' => 'Compilation :platform mise en file d\'attente avec succès ! Votre compilation sera traitée lorsqu\'un compilateur sera disponible. (:credits crédits restants)',
        'build_queued_success' => 'Compilation :platform mise en file d\'attente avec succès sur :builder ! (:credits crédits restants)',
        'available_builder' => 'compilateur disponible',
        'invalid_google_services_json' => 'Fichier JSON invalide. Veuillez téléverser un fichier google-services.json valide.',
        'invalid_google_services_structure' => 'google-services.json invalide. Section project_info ou client manquante.',
        'invalid_firebase_service_account' => 'Fichier JSON invalide. Veuillez téléverser un fichier de compte de service Firebase valide.',
        'invalid_firebase_service_account_type' => 'Fichier de compte de service Firebase invalide. Champ type manquant ou invalide.',
        'settings_save_failed_error' => 'Échec de l\'enregistrement des paramètres : :error',
        'file_delete_failed' => 'Échec de la suppression du fichier : :error',
        'credentials_delete_failed' => 'Échec de la suppression des identifiants : :error',
    ],

    // En-têtes des sections de l'éditeur
    'sections' => [
        'general' => 'Général',
        'general_description' => 'Informations de base et paramètres de configuration',
        'design' => 'Design',
        'design_description' => 'Personnalisez la mise en page, les couleurs et les paramètres du thème',
        'icon' => 'Icône',
        'icon_description' => 'Téléversez l\'icône de l\'application pour Android',
        'splashscreen' => 'Écran de démarrage',
        'splashscreen_description' => 'Configurez l\'apparence et l\'animation de l\'écran de démarrage',
        'navigation' => 'Navigation',
        'navigation_description' => 'Gérez les éléments de navigation et les boutons de la barre d\'application',
        'drawer' => 'Paramètres du tiroir',
        'drawer_description' => 'Personnalisez l\'apparence et l\'image de marque du menu tiroir',
        'webview' => 'Paramètres WebView',
        'webview_description' => 'Configurez le comportement et les fonctionnalités de la WebView',
        'permissions' => 'Permissions',
        'permissions_description' => 'Configurez les permissions d\'appareil que votre application demandera',
        'custom_code' => 'Code personnalisé',
        'custom_code_description' => 'Injectez du CSS et JavaScript personnalisés dans votre application',
        'hosted_pages' => 'Pages hébergées',
        'hosted_pages_description' => 'Créez des pages HTML personnalisées hébergées par nous pour votre application',
        'pages' => 'Pages',
        'add_page' => 'Ajouter une page',
        'notifications' => 'Notifications',
        'notifications_description' => 'Configurez Firebase Cloud Messaging pour les notifications',
        'builds' => 'Compilations',
        'builds_description' => 'Générez des fichiers APK et AAB Android pour le déploiement',
        'credits' => 'Crédits',
        'new_build' => 'Nouvelle compilation',
        'signing' => 'Signature',
        'signing_description' => 'Gérez les clés de signature pour la distribution de l\'application',
        // Sections spécifiques à WordPress
        'general_description_wordpress' => 'Informations de base et configuration du site WordPress',
        'content' => 'Contenu',
        'content_description' => 'Configurez l\'affichage des articles et les paramètres de contenu',
        'features' => 'Fonctionnalités',
        'features_description' => 'Activez ou désactivez les fonctionnalités de l\'application',
    ],

];
