<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => 'Informasi Dasar',
        'basic_information_description' => 'Detail penting tentang aplikasi Anda',
        'app_name' => 'Nama aplikasi',
        'app_name_placeholder' => 'Aplikasi Keren Saya',
        'app_name_help' => 'Ditampilkan di layar beranda perangkat',
        'website_url' => 'URL Website',
        'website_url_placeholder' => 'https://contoh.com',
        'website_url_help' => 'URL lengkap website atau web app Anda',
        'configuration' => 'Konfigurasi',
        'configuration_description' => 'Pengaturan teknis dan pengidentifikasi',
        'app_id' => 'APP ID',
        'app_id_tooltip' => 'Pengidentifikasi paket unik yang digunakan oleh app store',
        'app_id_placeholder' => 'com.contoh.aplikasi',
        'app_id_help' => 'App ID tidak dapat diubah setelah dibuat',
        'copy' => 'Salin',
        'copied' => 'Tersalin!',
        'screen_orientation' => 'Orientasi layar',
        'screen_orientation_help' => 'Mengontrol bagaimana aplikasi Anda berputar di perangkat',
        'orientation_system' => 'Sistem',
        'orientation_portrait' => 'Potret',
        'orientation_landscape' => 'Lanskap',
        'app_language' => 'Bahasa aplikasi (kode ISO)',
        'app_language_help' => 'Bahasa utama untuk konten aplikasi Anda',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'Template Tata Letak',
        'layout_template_description' => 'Pilih struktur navigasi untuk aplikasi Anda',
        'layout_app_bar_drawer' => 'App Bar + Drawer',
        'layout_app_bar_tabs' => 'App Bar + Tab Navigasi',
        'layout_app_bar' => 'App Bar',
        'layout_blank' => 'Kosong',
        'progress_indicator' => 'Indikator Progress',
        'progress_indicator_help' => 'Gaya indikator pemuatan yang ditampilkan saat halaman dimuat',
        'progress_disable' => 'Nonaktifkan',
        'progress_linear' => 'Linear',
        'progress_circular' => 'Melingkar',
        'progress_indicator_color' => 'Warna Indikator Progress',
        'progress_indicator_color_help' => 'Warna indikator progress pemuatan',
        'show_app_bar_title' => 'Tampilkan judul halaman web saat ini di app bar',
        'show_app_bar_title_help' => 'Tampilkan judul halaman saat ini di bar atas',
        'nav_tab_icon_colors' => 'Warna Ikon Tab Navigasi',
        'nav_tab_icon_colors_help' => 'Warna ikon tab tidak aktif dalam mode terang dan gelap',
        'active_tab_colors' => 'Warna Tab Aktif',
        'active_tab_colors_help' => 'Warna tab yang dipilih dalam mode terang dan gelap',
        'light_mode' => 'Mode Terang',
        'dark_mode' => 'Mode Gelap',
        'theme_colors' => 'Warna Tema',
        'theme_colors_description' => 'Warna utama yang mendefinisikan tampilan aplikasi Anda',
        'theme_color' => 'Warna Tema',
        'theme_color_help' => 'Warna utama yang digunakan di seluruh aplikasi Anda',
        'enable_dynamic_colors' => 'Aktifkan Warna Dinamis Material You (Android 12+)',
        'enable_dynamic_colors_help' => 'Saat diaktifkan, aplikasi Anda akan menyesuaikan warna dari wallpaper pengguna di perangkat Android 12+. Ini menimpa warna tema di atas.',
        'text_color_light' => 'Warna Teks (Mode Terang)',
        'text_color_light_help' => 'Warna teks dan ikon default dalam mode terang',
        'text_color_dark' => 'Warna Teks (Mode Gelap)',
        'text_color_dark_help' => 'Warna teks dan ikon default dalam mode gelap',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'Ikon Aplikasi',
        'app_icon_description' => 'Unggah ikon aplikasi Anda sebagai file ZIP dari icon.kitchen',
        'current_icon' => 'Ikon Saat Ini',
        'icon_zip_uploaded' => 'ZIP Ikon diunggah',
        'icon_zip_uploaded_description' => 'Ikon yang diekstrak tersedia untuk platform Android dan Web',
        'default_icon' => 'Ikon Default',
        'default_icon_description' => 'Unggah ikon kustom untuk mengganti default',
        'delete' => 'Hapus',
        'upload_zip_file' => 'Unggah File ZIP',
        'upload_zip_help' => 'File ZIP dari icon.kitchen (MAKS. 10MB)',
        'how_to_create' => 'Cara membuat ikon Anda:',
        'step_visit' => 'Kunjungi',
        'step_design' => 'Desain ikon aplikasi Anda',
        'step_download' => 'Unduh file ZIP yang berisi semua ikon platform',
        'step_upload' => 'Unggah file ZIP di sini',
        'zip_file_info' => 'File ZIP harus berisi ikon untuk platform Android dan Web (Maks 10MB)',
        'upload_icon' => 'Unggah Ikon',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'Tampilan Splashscreen',
        'appearance_description' => 'Sesuaikan latar belakang, durasi tampilan, dan efek animasi',
        'background_type' => 'Tipe Latar Belakang',
        'background_type_color' => 'Warna Solid',
        'background_type_image' => 'Gambar Latar Belakang',
        'background_color' => 'Warna Latar Belakang',
        'background_image' => 'Gambar Latar Belakang',
        'background_image_help' => 'Hanya PNG (MAKS. 2MB)',
        'delete_background_image' => 'Hapus Gambar Latar Belakang',
        'display_duration' => 'Durasi Tampilan:',
        'seconds' => 'detik',
        'animation_effect' => 'Efek Animasi',
        'animation_fade' => 'Pudar',
        'animation_slide' => 'Geser',
        'animation_zoom' => 'Zoom',
        'animation_none' => 'Tidak Ada',
        'branding' => 'Branding Splashscreen',
        'branding_description' => 'Tambahkan logo, judul, subjudul, dan styling teks ke splashscreen Anda',
        'show_logo' => 'Tampilkan Logo di Splashscreen',
        'logo_image' => 'Gambar Logo',
        'logo_image_help' => 'PNG dengan transparansi disarankan (MAKS. 2MB)',
        'delete_logo' => 'Hapus Logo',
        'logo_size' => 'Ukuran Logo:',
        'logo_size_small' => 'Kecil (60dp)',
        'logo_size_medium' => 'Sedang (150dp)',
        'logo_size_large' => 'Besar (240dp)',
        'logo_size_help' => 'Sesuaikan ukuran logo untuk tampilan optimal',
        'title' => 'Judul',
        'title_placeholder' => 'Aplikasi Keren Saya',
        'subtitle' => 'Subjudul',
        'subtitle_placeholder' => 'Selamat datang di aplikasi terbaik',
        'text_theme' => 'Tema Teks',
        'text_theme_light' => 'Terang (Teks putih)',
        'text_theme_dark' => 'Gelap (Teks hitam)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'Tampilan Drawer',
        'appearance_description' => 'Sesuaikan latar belakang dan gaya visual drawer navigasi Anda',
        'drawer_mode' => 'Mode Drawer',
        'drawer_mode_help' => 'Pilih bagaimana latar belakang drawer harus muncul',
        'mode_default' => 'Default (Warna Tema)',
        'mode_color' => 'Warna Kustom',
        'mode_image' => 'Gambar Latar Belakang',
        'background_color' => 'Warna Latar Belakang',
        'background_color_help' => 'Warna latar belakang kustom untuk drawer',
        'background_image' => 'Gambar Latar Belakang',
        'background_image_help' => 'Hanya PNG (MAKS. 2MB). Disarankan: 1080x1920px',
        'delete_background_image' => 'Hapus Gambar Latar Belakang',
        'branding' => 'Branding Drawer',
        'branding_description' => 'Tambahkan logo, judul, dan sesuaikan tampilan teks di header drawer',
        'show_logo' => 'Tampilkan Logo di Drawer',
        'show_logo_help' => 'Tampilkan logo di header drawer',
        'logo_light' => 'Logo Drawer (Mode Terang)',
        'logo_light_help' => 'PNG dengan transparansi diperlukan (MAKS. 2MB) - Ditampilkan saat aplikasi dalam tema terang',
        'delete_light_logo' => 'Hapus Logo Terang',
        'logo_dark' => 'Logo Drawer (Mode Gelap)',
        'logo_dark_help' => 'PNG dengan transparansi diperlukan (MAKS. 2MB) - Ditampilkan saat aplikasi dalam tema gelap',
        'delete_dark_logo' => 'Hapus Logo Gelap',
        'logo_size' => 'Ukuran Logo:',
        'logo_size_small' => 'Kecil (40dp)',
        'logo_size_medium' => 'Sedang (120dp)',
        'logo_size_large' => 'Besar (200dp)',
        'logo_size_help' => 'Sesuaikan ukuran logo untuk tampilan optimal',
        'drawer_title' => 'Judul Drawer',
        'drawer_title_placeholder' => 'Aplikasi Saya',
        'drawer_title_help' => 'Judul ditampilkan di header drawer',
        'drawer_subtitle' => 'Subjudul Drawer',
        'drawer_subtitle_placeholder' => 'Selamat datang di aplikasi saya',
        'drawer_subtitle_help' => 'Subjudul atau tagline ditampilkan di bawah judul',
        'text_theme' => 'Tema Teks',
        'text_theme_help' => 'Warna teks untuk header drawer dan item menu',
        'text_theme_light' => 'Terang (Teks putih)',
        'text_theme_dark' => 'Gelap (Teks hitam)',
        'item_colors' => 'Warna Item Drawer',
        'item_colors_description' => 'Sesuaikan warna ikon dan teks untuk item menu drawer',
        'item_icon_colors' => 'Warna Ikon Item Drawer',
        'item_icon_colors_help' => 'Warna ikon dan teks item drawer tidak aktif dalam mode terang dan gelap',
        'active_item_colors' => 'Warna Item Aktif',
        'active_item_colors_help' => 'Warna item drawer yang dipilih/aktif dalam mode terang dan gelap',
        'light_mode' => 'Mode Terang',
        'dark_mode' => 'Mode Gelap',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'Bar Navigasi Bawah',
        'bottom_nav_bar_description' => 'Konfigurasi item tab navigasi bawah (maks 8 item)',
        'add_item' => '+ Tambah Item',
        'no_navigation_items' => 'Tidak ada item navigasi dikonfigurasi',
        'add_first_navigation_item' => 'Tambahkan item navigasi pertama Anda',
        'home_tab_badge' => 'Tab Beranda - Disinkronkan ke URL Utama',
        'home_item_badge' => 'Item Beranda - Disinkronkan ke URL Utama',
        'label' => 'Label',
        'label_placeholder_home' => 'Beranda',
        'label_placeholder_about' => 'Tentang Kami',
        'action_type' => 'Tipe Aksi',
        'action_internal' => 'Tautan Internal',
        'action_external' => 'Tautan Eksternal',
        'action_hosted_page' => 'Halaman Hosted',
        'action_share' => 'Bagikan',
        'action_email' => 'Kirim Email',
        'action_call' => 'Panggil Telepon',
        'url' => 'URL',
        'email_address' => 'Alamat Email',
        'phone_number' => 'Nomor Telepon',
        'hosted_page' => 'Halaman Hosted',
        'select_page' => 'Pilih halaman',
        'synced_from_general' => 'Disinkronkan secara otomatis dari Pengaturan Umum',
        'icon' => 'Ikon',
        'select_icon' => 'Pilih Ikon',
        'search_icons' => 'Cari ikon...',
        'home_tab_cannot_delete' => 'Tab beranda tidak dapat dihapus',
        'home_item_cannot_delete' => 'Item beranda tidak dapat dihapus',
        'max_navigation_items' => 'Maksimum 8 item navigasi tercapai (tidak termasuk tab Beranda)',
        'app_bar_buttons' => 'Tombol App Bar',
        'app_bar_buttons_description' => 'Tambahkan tombol aksi di kanan atas app bar (maks 3 tombol)',
        'add_button' => '+ Tambah Tombol',
        'no_app_bar_buttons' => 'Tidak ada tombol app bar dikonfigurasi',
        'add_first_app_bar_button' => 'Tambahkan tombol app bar pertama Anda',
        'max_app_bar_buttons' => 'Maksimum 3 tombol app bar tercapai',
        'drawer_menu_items' => 'Item Menu Drawer',
        'drawer_menu_items_description' => 'Konfigurasi item menu drawer navigasi (1 beranda + hingga 9 item tambahan)',
        'no_drawer_items' => 'Tidak ada item menu drawer dikonfigurasi',
        'add_first_drawer_item' => 'Tambahkan item menu drawer pertama Anda',
        'max_drawer_items' => 'Maksimum 9 item tambahan tercapai (10 total termasuk item beranda)',
        'behavior_settings' => 'Pengaturan Perilaku',
        'behavior_settings_description' => 'Konfigurasi interaksi pengguna',
        'pull_to_refresh' => 'Tarik untuk Refresh',
        'pull_to_refresh_description' => 'Izinkan pengguna merefresh konten dengan menarik ke bawah',
        'swipe_navigation' => 'Navigasi Geser',
        'swipe_navigation_description' => 'Izinkan pengguna menavigasi kembali dengan menggeser dari tepi',
        'swipe_navigation_disabled' => 'Dinonaktifkan untuk tata letak drawer untuk mencegah konflik gesture',
        'preserve_tab_state' => 'Pertahankan Status Tab',
        'preserve_tab_state_description' => 'Pertahankan halaman saat ini saat beralih antar tab/item drawer',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'Pengaturan aplikasi',
        'general' => 'Umum',
        'design' => 'Desain',
        'icon' => 'Ikon',
        'splashscreen' => 'Splashscreen',
        'navigation' => 'Navigasi',
        'drawer' => 'Drawer',
        'webview' => 'WebView',
        'permissions' => 'Izin',
        'custom_code' => 'Kode Kustom',
        'hosted_pages' => 'Halaman Hosted',
        'notifications' => 'Notifikasi',
        'deployment' => 'Deployment',
        'builds' => 'Build',
        'signing' => 'Penandatanganan',
        'back_to_apps' => 'Kembali ke Aplikasi',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'User Agent',
    'webview_user_agent_description' => 'Sesuaikan string user agent browser',
    'webview_custom_user_agent' => 'User Agent Kustom',
    'webview_user_agent_placeholder' => 'Biarkan kosong untuk menggunakan user agent WebView Android default',
    'webview_user_agent_helper' => 'Opsional. Timpa user agent default yang dikirim ke website Anda.',
    'webview_features_title' => 'Fitur WebView',
    'webview_features_description' => 'Konfigurasi kemampuan dan perilaku browser',
    'webview_enable_javascript' => 'Aktifkan JavaScript',
    'webview_enable_javascript_description' => 'Izinkan eksekusi JavaScript di WebView',
    'webview_enable_dom_storage' => 'Aktifkan DOM Storage',
    'webview_enable_dom_storage_description' => 'Izinkan API localStorage dan sessionStorage',
    'webview_enable_zoom_controls' => 'Aktifkan Kontrol Zoom',
    'webview_enable_zoom_controls_description' => 'Izinkan pinch-to-zoom dan kontrol zoom',
    'webview_enable_cache' => 'Aktifkan Cache',
    'webview_enable_cache_description' => 'Cache konten web untuk pemuatan lebih cepat',

    // Permissions Settings
    'permissions_location_title' => 'Izin Lokasi',
    'permissions_location_description' => 'Akses GPS perangkat untuk fitur berbasis lokasi',
    'permissions_enable_location' => 'Aktifkan Akses Lokasi',
    'permissions_location_helper' => 'Diperlukan untuk peta, konten berbasis lokasi, dan fitur geofencing.',
    'permissions_show_code_example' => 'Tampilkan contoh kode',
    'permissions_hide_code_example' => 'Sembunyikan contoh kode',
    'permissions_javascript_example' => 'Contoh JavaScript:',
    'permissions_camera_title' => 'Izin Kamera',
    'permissions_camera_description' => 'Akses kamera perangkat untuk foto dan video',
    'permissions_enable_camera' => 'Aktifkan Akses Kamera',
    'permissions_camera_helper' => 'Diperlukan untuk mengambil foto, memindai kode QR, dan panggilan video.',
    'permissions_storage_title' => 'Izin Penyimpanan',
    'permissions_storage_description' => 'Akses penyimpanan perangkat untuk unggah dan unduh file',
    'permissions_enable_storage' => 'Aktifkan Akses Penyimpanan',
    'permissions_storage_helper' => 'Diperlukan untuk unggah file, pemilih gambar, dan mengunduh file.',
    'permissions_microphone_title' => 'Izin Mikrofon',
    'permissions_microphone_description' => 'Akses mikrofon perangkat untuk perekaman audio',
    'permissions_enable_microphone' => 'Aktifkan Akses Mikrofon',
    'permissions_microphone_helper' => 'Diperlukan untuk perekaman suara, panggilan audio, dan pengenalan suara.',
    'permissions_contacts_title' => 'Izin Kontak',
    'permissions_contacts_description' => 'Akses kontak perangkat untuk fitur sosial',
    'permissions_enable_contacts' => 'Aktifkan Akses Kontak',
    'permissions_contacts_helper' => 'Diperlukan untuk pemilih kontak, fitur undangan, dan integrasi sosial.',
    'permissions_vibrate_title' => 'Izin Getar',
    'permissions_vibrate_description' => 'Akses motor getar perangkat untuk umpan balik haptic',
    'permissions_enable_vibrate' => 'Aktifkan Getar',
    'permissions_vibrate_helper' => 'Diperlukan untuk umpan balik haptic dan getaran notifikasi.',

    // Custom Code Settings
    'custom_code_access_required_title' => 'Upgrade Diperlukan',
    'custom_code_access_required_description' => 'Paket Anda saat ini tidak termasuk injeksi kode kustom. Upgrade untuk mengakses fitur ini dan menambahkan CSS dan JavaScript kustom ke aplikasi Anda.',
    'custom_code_upgrade_plan' => 'Upgrade paket Anda',
    'custom_code_enable_feature' => 'untuk mengaktifkan fitur ini.',
    'custom_code_css_title' => 'CSS Kustom',
    'custom_code_css_description' => 'Tambahkan style kustom untuk mempersonalisasi tampilan aplikasi Anda',
    'custom_code_css_label' => 'Kode CSS',
    'custom_code_css_helper' => 'Maksimum 100KB. CSS akan diinjeksikan ke setiap halaman.',
    'custom_code_js_title' => 'JavaScript Kustom',
    'custom_code_js_description' => 'Tambahkan script kustom untuk fungsionalitas tambahan',
    'custom_code_js_label' => 'Kode JavaScript',
    'custom_code_js_helper' => 'Maksimum 100KB. JavaScript akan dieksekusi di webview.',

    // Notifications Settings
    'notifications_title' => 'Notifikasi',
    'notifications_description' => 'Konfigurasi Firebase Cloud Messaging (FCM) untuk notifikasi',
    'notifications_enable' => 'Aktifkan Notifikasi',
    'notifications_firebase_service_account' => 'Akun Layanan Firebase',
    'notifications_firebase_service_account_description' => 'Digunakan oleh server untuk mengirim notifikasi melalui API FCM',
    'notifications_firebase_help_text' => 'File JSON (MAKS. 2MB)',
    'notifications_delete_firebase_credentials' => 'Hapus Kredensial Firebase',
    'notifications_delete_firebase_credentials_confirm' => 'Apakah Anda yakin ingin menghapus file kredensial Firebase?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Diperlukan untuk konfigurasi aplikasi Android',
    'notifications_google_services_help_text' => 'File JSON (MAKS. 1MB)',
    'notifications_delete_google_services' => 'Hapus File Google Services',
    'notifications_delete_google_services_confirm' => 'Apakah Anda yakin ingin menghapus file Google Services?',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Keystore Android',
        'generate_new' => 'Hasilkan Baru',
        'upload_existing' => 'Unggah yang Ada',
        'default_badge' => 'Default',
        'alias' => 'Alias',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => 'Dihasilkan otomatis',
        'created' => 'Dibuat',
        'set_as_default' => 'Jadikan Default',
        'edit' => 'Ubah',
        'delete' => 'Hapus',
        'no_keystores' => 'Belum ada keystore Android. Hasilkan kunci baru atau unggah yang sudah ada.',
        'upload_signing_key' => 'Unggah Kunci Penandatanganan',
        'android_keystore_upload' => 'Unggah Keystore Android',
        'keystore_name' => 'Nama Keystore',
        'keystore_name_placeholder' => 'Keystore Rilis Saya',
        'keystore_file' => 'File Keystore',
        'keystore_file_help' => 'File .jks, .keystore, atau .ks (Maks 5MB)',
        'upload_custom_key' => 'Unggah kunci kustom',
        'upload_custom_key_help' => 'Hapus centang jika menggunakan keystore debug yang dihasilkan otomatis',
        'password' => 'Password',
        'password_placeholder' => '••••••••',
        'password_help' => 'Digunakan untuk akses keystore dan kunci',
        'cancel' => 'Batal',
        'upload' => 'Unggah',
        'edit_keystore' => 'Ubah Keystore',
        'update_password' => 'Perbarui password',
        'save' => 'Simpan',
        'delete_keystore' => 'Hapus Keystore',
        'delete_confirmation' => 'Apakah Anda yakin ingin menghapus',
        'action_cannot_be_undone' => 'Tindakan ini tidak dapat dibatalkan.',

        // Keystore Generator Modal
        'generate_signing_key' => 'Hasilkan Kunci Penandatanganan',
        'generate_android_keystore' => 'Hasilkan Keystore Android',
        'generate_keystore_description' => 'Keystore JKS baru akan dihasilkan dengan aman di server build',
        'keystore_name_generate_placeholder' => 'Kunci Rilis Aplikasi Saya',
        'key_alias' => 'Alias Kunci',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => 'Harus dimulai dengan huruf. Huruf, angka, tanda hubung, dan garis bawah diizinkan.',
        'password_settings' => 'Pengaturan Password',
        'keystore_password' => 'Password Keystore',
        'min_characters_placeholder' => 'Min. 6 karakter',
        'use_same_password' => 'Gunakan password yang sama untuk kunci dan keystore',
        'key_password' => 'Password Kunci',
        'validity_period' => 'Periode Validitas',
        'years_10' => '10 tahun',
        'years_15' => '15 tahun',
        'years_20' => '20 tahun',
        'years_25_recommended' => '25 tahun (Disarankan)',
        'years_30' => '30 tahun',
        'validity_help' => 'Google Play memerlukan validitas minimal 25 tahun untuk aplikasi baru',
        'certificate_details' => 'Detail Sertifikat (Opsional)',
        'common_name' => 'Nama Umum (CN)',
        'common_name_placeholder' => 'Nama aplikasi atau organisasi Anda',
        'organization' => 'Organisasi (O)',
        'organization_placeholder' => 'Nama Perusahaan',
        'organizational_unit' => 'Unit Organisasi (OU)',
        'organizational_unit_placeholder' => 'Aplikasi Mobile',
        'city' => 'Kota (L)',
        'city_placeholder' => 'Jakarta',
        'state' => 'Provinsi (ST)',
        'state_placeholder' => 'DKI Jakarta',
        'country' => 'Negara (C)',
        'country_placeholder' => 'ID',
        'save_password_warning' => 'Penting: Simpan password Anda dengan aman!',
        'save_password_description' => 'Keystore akan dienkripsi dan disimpan. Anda akan memerlukan password untuk build di masa depan. Tidak ada cara untuk memulihkan password yang hilang.',
        'generating' => 'Menghasilkan...',
        'generate_keystore' => 'Hasilkan Keystore',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'Akses Halaman Hosted Diperlukan',
        'upgrade_description' => 'Paket Anda saat ini tidak termasuk halaman hosted. Upgrade paket Anda untuk membuat halaman kustom yang di-host oleh kami.',
        'upgrade_plan' => 'Upgrade paket Anda',
        'upgrade_suffix' => 'untuk mengaktifkan fitur ini.',
        'table_page' => 'Halaman',
        'table_status' => 'Status',
        'table_created' => 'Dibuat',
        'table_actions' => 'Aksi',
        'status_published' => 'Dipublikasikan',
        'status_draft' => 'Draf',
        'edit' => 'Ubah',
        'delete' => 'Hapus',
        'no_pages' => 'Belum ada halaman',
        'no_pages_description' => 'Klik "Tambah Halaman" untuk membuat halaman hosted pertama Anda.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'Buat Halaman',
        'edit_page' => 'Ubah Halaman',
        'title' => 'Judul',
        'title_placeholder' => 'Judul halaman',
        'slug' => 'Slug',
        'slug_placeholder' => 'slug-halaman',
        'start_from_template' => 'Mulai dari template',
        'status' => 'Status',
        'status_help' => 'Hanya halaman yang dipublikasikan yang dapat diakses di aplikasi',
        'cancel' => 'Batal',
        'save_changes' => 'Simpan Perubahan',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'Aplikasi WordPress Saya',
        'wordpress_site_url' => 'URL Situs WordPress',
        'wordpress_site_url_placeholder' => 'https://blogku.wordpress.com',
        'wordpress_site_url_help' => 'Masukkan URL situs WordPress.com Anda (mis., blogku.wordpress.com)',
        'app_id_placeholder' => 'com.contoh.wordpress',
        'package_name_help' => 'Pengidentifikasi unik dalam format domain terbalik (mis., com.perusahaan.wordpress). Tidak dapat diubah setelah dibuat.',

        // Design Settings
        'post_list_style' => 'Gaya Daftar Postingan',
        'style_list' => 'Daftar',
        'style_grid' => 'Grid',
        'style_magazine' => 'Majalah',
        'post_list_style_help' => 'Bagaimana postingan ditampilkan di aplikasi',
        'progress_indicator_help' => 'Gaya indikator pemuatan yang ditampilkan saat mengambil postingan',
        'show_app_bar_title' => 'Tampilkan nama aplikasi di app bar',
        'show_app_bar_title_help' => 'Tampilkan nama aplikasi Anda di bar atas',
        'nav_tab_icon_colors_help' => 'Warna ikon tab tidak aktif',
        'active_tab_colors_help' => 'Warna tab yang dipilih',
        'theme_color_help' => 'Warna utama yang digunakan di seluruh aplikasi Anda (WordPress biru: #21759B)',
        'dynamic_colors_help' => 'Saat diaktifkan, aplikasi Anda akan menyesuaikan warna dari wallpaper pengguna di perangkat Android 12+.',
        'layout_list_only' => 'Hanya Daftar',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'Aplikasi WordPress Saya',
        'splashscreen_subtitle_placeholder' => 'Selamat datang di aplikasi blog terbaik',

        // Sidebar
        'content' => 'Konten',
        'features' => 'Fitur',

        // Drawer Settings
        'drawer_appearance_description' => 'Sesuaikan latar belakang drawer navigasi',
        'drawer_branding_description' => 'Logo, judul, dan styling teks',
        'logo_light_mode' => 'Logo (Mode Terang)',
        'logo_dark_mode' => 'Logo (Mode Gelap)',
        'png_transparency_help' => 'PNG dengan transparansi (MAKS. 2MB)',
        'delete_background' => 'Hapus Latar Belakang',
        'drawer_title_placeholder' => 'Aplikasi WordPress Saya',
        'drawer_subtitle_placeholder' => 'Tagline Anda di sini',
        'item_colors_description' => 'Warna ikon dan teks untuk item menu',
        'inactive_item_colors' => 'Warna Item Tidak Aktif',

        // Navigation Settings
        'bottom_nav_tabs' => 'Tab Navigasi Bawah',
        'bottom_nav_tabs_description' => 'Konfigurasi item navigasi bawah (maks 8 + beranda)',
        'add_tab' => '+ Tambah Tab',
        'home_tab_shows_all_posts' => 'Tab Beranda - Menampilkan Semua Postingan',
        'home_item_shows_all_posts' => 'Item Beranda - Menampilkan Semua Postingan',
        'tab_name_placeholder' => 'Nama Tab',
        'menu_item_placeholder' => 'Item Menu',
        'action_category' => 'Kategori',
        'action_tag' => 'Tag',
        'action_search' => 'Cari',
        'action_bookmarks' => 'Markah',
        'action_share' => 'Bagikan',
        'category_slug' => 'Slug Kategori',
        'tag_slug' => 'Slug Tag',
        'category_slug_placeholder' => 'teknologi',
        'tag_slug_placeholder' => 'unggulan',
        'app_bar_buttons_description' => 'Tombol aksi di kanan atas (maks 3)',
        'no_app_bar_buttons_description' => 'Tidak ada tombol app bar dikonfigurasi. Tambahkan pencarian, bagikan, atau aksi cepat lainnya.',
        'search_placeholder' => 'Cari',
        'drawer_menu_items_description' => 'Item menu drawer navigasi (1 beranda + hingga 9 item)',
        'swipe_navigation_description' => 'Navigasi kembali dengan menggeser dari tepi',
        'preserve_tab_state_description' => 'Pertahankan posisi scroll saat beralih tab',

        // Content Settings
        'post_display' => 'Tampilan Postingan',
        'post_display_description' => 'Konfigurasi bagaimana postingan ditampilkan di aplikasi Anda',
        'posts_per_page' => 'Postingan Per Halaman',
        'posts_per_page_help' => 'Jumlah postingan yang dimuat sekaligus (1-50)',
        'excerpt_length' => 'Panjang Kutipan (karakter)',
        'excerpt_length_help' => 'Karakter maksimum yang ditampilkan dalam kutipan postingan (50-500)',
        'post_metadata' => 'Metadata Postingan',
        'post_metadata_description' => 'Pilih informasi apa yang ditampilkan dengan setiap postingan',
        'show_featured_image' => 'Tampilkan gambar unggulan',
        'show_featured_image_help' => 'Tampilkan gambar unggulan/thumbnail postingan',
        'show_excerpt' => 'Tampilkan kutipan postingan',
        'show_excerpt_help' => 'Tampilkan pratinjau konten postingan',
        'show_author' => 'Tampilkan nama penulis',
        'show_author_help' => 'Tampilkan penulis yang menulis postingan',
        'show_date' => 'Tampilkan tanggal publikasi',
        'show_date_help' => 'Tampilkan kapan postingan dipublikasikan',
        'show_categories' => 'Tampilkan kategori',
        'show_categories_help' => 'Tampilkan kategori yang ditetapkan ke postingan',
        'show_reading_time' => 'Tampilkan perkiraan waktu baca',
        'show_reading_time_help' => 'Tampilkan berapa lama waktu untuk membaca postingan',

        // Features Settings
        'core_features' => 'Fitur Inti',
        'core_features_description' => 'Aktifkan atau nonaktifkan fungsionalitas aplikasi',
        'enable_search' => 'Aktifkan pencarian',
        'enable_search_help' => 'Izinkan pengguna mencari postingan di aplikasi Anda',
        'enable_comments' => 'Aktifkan komentar',
        'enable_comments_help' => 'Izinkan pengguna melihat dan memposting komentar pada artikel',
        'enable_bookmarks' => 'Aktifkan markah',
        'enable_bookmarks_help' => 'Izinkan pengguna menyimpan postingan untuk dibaca nanti',
        'enable_share' => 'Aktifkan berbagi',
        'enable_share_help' => 'Izinkan pengguna berbagi postingan melalui aplikasi lain',
        'advanced_features' => 'Fitur Lanjutan',
        'advanced_features_description' => 'Fungsionalitas tambahan untuk pengalaman pengguna yang lebih baik',
        'enable_offline_reading' => 'Aktifkan pembacaan offline',
        'enable_offline_reading_help' => 'Cache postingan untuk dibaca tanpa koneksi internet',
        'enable_user_auth' => 'Aktifkan autentikasi pengguna',
        'enable_user_auth_help' => 'Izinkan pengguna masuk dengan akun WordPress.com mereka',
        'enable_push_notifications' => 'Aktifkan notifikasi push',
        'enable_push_notifications_help' => 'Kirim notifikasi saat postingan baru dipublikasikan',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'Cari build...',
        'filter' => 'Filter',
        'platform_filter' => 'Platform',
        'status_filter' => 'Status',
        'android' => 'Android',
        'completed' => 'Selesai',
        'building' => 'Membangun',
        'failed' => 'Gagal',
        'pending' => 'Menunggu',
        'table_platform' => 'Platform',
        'table_build_info' => 'Info Build',
        'table_created' => 'Dibuat',
        'table_actions' => 'Aksi',
        'release' => 'Rilis',
        'debug' => 'Debug',
        'download' => 'Unduh',
        'preview' => 'Pratinjau',
        'logs' => 'Log',
        'delete' => 'Hapus',
        'no_builds' => 'Tidak ada build ditemukan',

        // Build Modal
        'create_new_build' => 'Buat Build Baru',
        'platform_label' => 'Platform',
        'build_costs_credit' => 'Build memerlukan :count kredit',
        'build_type_label' => 'Tipe Build',
        'for_testing' => 'Untuk pengujian',
        'for_production' => 'Untuk produksi',
        'output_format_label' => 'Format Output',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'Untuk pengujian/sideloading',
        'for_google_play_store' => 'Untuk Google Play Store',
        'builder_label' => 'Builder',
        'auto_select_recommended' => 'Pilih otomatis (disarankan)',
        'auto_select_help' => 'Biarkan "Pilih otomatis" untuk menggunakan builder yang paling tidak sibuk, atau pilih builder tertentu.',
        'no_builders_available' => 'Tidak ada builder tersedia!',
        'no_builders_help' => 'Paket Anda tidak memiliki akses ke builder mana pun. Silakan hubungi dukungan atau upgrade paket Anda.',
        'signing_key_label' => 'Kunci Penandatanganan',
        'select_keystore' => 'Pilih keystore',
        'no_keystores_available' => 'Tidak ada keystore tersedia.',
        'upload_in_signing_section' => 'Unggah di bagian Penandatanganan',
        'signing_key_required' => 'Kunci penandatanganan diperlukan!',
        'version_name_label' => 'Nama Versi',
        'version_name_help' => 'Format: X.Y atau X.Y.Z (mis., 1.0 atau 1.0.0). Dinaikkan otomatis untuk setiap platform.',
        'build_number_label' => 'Nomor Build',
        'next_build_number' => 'Nomor Build Berikutnya',
        'build_number_auto_increment' => 'Nomor build otomatis naik dengan setiap build',
        'build_cost_info' => 'Build ini akan memerlukan :count kredit',
        'build_email_notification' => 'Anda akan menerima email saat build siap diunduh.',
        'cancel' => 'Batal',
        'start_build' => 'Mulai Build',
        'credit' => 'kredit',
        'credits' => 'kredit',
        'builder_info' => 'Builder:',

        // Build Logs Modal
        'build_logs' => 'Log Build',
        'duration' => 'Durasi:',
        'no_logs_available' => 'Tidak ada log tersedia untuk build ini',
        'error' => 'Error:',
        'close' => 'Tutup',
        'download_build' => 'Unduh Build',

        // Build Download Modal
        'download_build_title' => 'Unduh Build',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'Ini adalah file AAB yang tidak dapat langsung diinstal di perangkat. File AAB dirancang untuk diunggah ke Google Play Console, di mana Google akan menghasilkan APK yang dioptimalkan untuk pengguna.',
        'scan_with_android' => 'Scan dengan perangkat Android Anda',
        'qr_unavailable' => 'Kode QR tidak tersedia',
        'download_options' => 'Opsi Unduh',
        'download_options_description' => 'Scan kode QR dengan perangkat mobile Anda atau gunakan tautan unduh langsung di bawah.',
        'download_format' => 'Unduh :format',
        'installation_note' => 'Instalasi:',
        'installation_help' => 'Anda mungkin perlu mengaktifkan "Instal dari Sumber Tidak Dikenal" di pengaturan Android Anda.',
        'download_aab_file' => 'Unduh File AAB',
        'upload_to_play_console' => 'Unggah file ini ke Google Play Console untuk mempublikasikan aplikasi Anda.',
        'next_steps' => 'Langkah Selanjutnya:',
        'next_steps_help' => 'Unggah file AAB ini ke Google Play Console di bawah Release > Production/Testing. Google akan secara otomatis menghasilkan APK yang dioptimalkan untuk pengguna Anda.',

        // Delete Build Modal
        'delete_build' => 'Hapus Build',
        'delete_confirmation' => 'Apakah Anda yakin ingin menghapus',
        'build_suffix' => 'build?',
        'action_cannot_be_undone' => 'Tindakan ini tidak dapat dibatalkan.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'Tidak Ada Build Dipilih',
        'select_build_help' => 'Pilih build yang selesai dari tab Build untuk melihat pratinjaunya di sini',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'URL Website',
        'app_id' => 'APP ID',
        'app_id_tooltip' => 'Pengidentifikasi paket unik (tidak dapat diubah setelah dibuat)',
        'auto_generate_package' => 'Hasilkan otomatis dari nama aplikasi',
        'package_name_help' => 'Pengidentifikasi unik dalam format domain terbalik (mis., com.perusahaan.aplikasi). Tidak dapat diubah setelah dibuat.',
        'theme_color' => 'Warna Tema',
        'theme_color_help' => 'Warna utama yang digunakan di seluruh aplikasi Anda. Warna teks akan menggunakan hitam/putih default dan dapat disesuaikan nanti.',
        'layout_template' => 'Template tata letak',
        'layout_app_bar_drawer' => 'App Bar + Drawer',
        'layout_app_bar_tabs' => 'App Bar + Tab Navigasi',
        'layout_app_bar' => 'App Bar',
        'layout_blank' => 'Kosong',
        'layout_help' => 'Pilih struktur navigasi untuk aplikasi Anda',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'Batal',
        'delete' => 'Hapus',
        'action_cannot_be_undone' => 'Tindakan ini tidak dapat dibatalkan.',
        'delete_build' => 'Hapus Build',
        'delete_build_confirmation' => 'Apakah Anda yakin ingin menghapus',
        'build_suffix' => 'build?',
        'delete_app_icon' => 'Hapus Ikon Aplikasi',
        'delete_icon_confirmation' => 'Apakah Anda yakin ingin menghapus ikon untuk',
        'delete_keystore' => 'Hapus Keystore',
        'delete_keystore_confirmation' => 'Apakah Anda yakin ingin menghapus',
        'delete_splashscreen_background' => 'Hapus Latar Belakang Splashscreen',
        'delete_splashscreen_background_confirmation' => 'Apakah Anda yakin ingin menghapus gambar latar belakang splashscreen untuk',
        'delete_splashscreen_logo' => 'Hapus Logo Splashscreen',
        'delete_splashscreen_logo_confirmation' => 'Apakah Anda yakin ingin menghapus logo splashscreen untuk',
        'delete_drawer_background' => 'Hapus Latar Belakang Drawer',
        'delete_drawer_background_confirmation' => 'Apakah Anda yakin ingin menghapus gambar latar belakang drawer untuk',
        'delete_dark_mode_logo' => 'Hapus Logo Mode Gelap',
        'delete_dark_mode_logo_confirmation' => 'Apakah Anda yakin ingin menghapus logo mode gelap drawer untuk',
        'delete_light_mode_logo' => 'Hapus Logo Mode Terang',
        'delete_light_mode_logo_confirmation' => 'Apakah Anda yakin ingin menghapus logo mode terang drawer untuk',
        'delete_page' => 'Hapus Halaman',
        'delete_page_confirmation' => 'Apakah Anda yakin ingin menghapus',
        'delete_page_warning' => 'Tindakan ini tidak dapat dibatalkan. Jika halaman ini digunakan di navigasi Anda, halaman tidak akan lagi dapat diakses.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'Notifikasi Push',
        'description' => 'Konfigurasi Firebase Cloud Messaging untuk notifikasi push',
        'enable_label' => 'Aktifkan notifikasi push',
        'enable_help' => 'Kirim notifikasi saat postingan baru dipublikasikan',
        'firebase_required_title' => 'Konfigurasi Firebase Diperlukan',
        'firebase_required_description' => 'Unggah kedua file konfigurasi di bawah untuk mengaktifkan notifikasi push di aplikasi Anda.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'File diunggah',
        'google_services_configured' => 'google-services.json dikonfigurasi',
        'delete' => 'Hapus',
        'delete_file_confirm' => 'Apakah Anda yakin ingin menghapus file ini?',
        'upload_google_services' => 'Unggah google-services.json',
        'google_services_help' => 'Unduh dari Firebase Console (MAKS. 1MB)',
        'google_services_instructions' => 'Unduh dari Firebase Console > Project Settings > Your apps > Android app',
        'firebase_service_account_label' => 'Akun Layanan Firebase (untuk mengirim notifikasi)',
        'credentials_configured' => 'Kredensial dikonfigurasi',
        'service_account_stored' => 'Akun layanan disimpan dengan aman',
        'delete_credentials_confirm' => 'Apakah Anda yakin ingin menghapus kredensial ini?',
        'upload_service_account' => 'Unggah JSON Akun Layanan',
        'service_account_help' => 'Unduh dari Firebase Console (MAKS. 2MB)',
        'service_account_instructions' => 'Unduh dari Firebase Console > Project Settings > Service Accounts > Generate new private key',
        'setup_title' => 'Cara mengatur Firebase:',
        'setup_step_1' => 'Buka',
        'setup_step_2' => 'Buat proyek atau pilih yang sudah ada',
        'setup_step_3' => 'Tambahkan aplikasi Android dengan nama paket Anda:',
        'setup_step_4' => 'Unduh',
        'setup_step_4_suffix' => 'dan unggah di atas',
        'setup_step_5' => 'Buka Project Settings > Service Accounts',
        'setup_step_6' => 'Hasilkan private key baru dan unggah di atas',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => 'Pengaturan :section berhasil disimpan!',
        'settings_save_failed' => 'Gagal menyimpan pengaturan. Silakan coba lagi.',

        // Design settings
        'design_saved' => 'Pengaturan desain berhasil disimpan!',

        // Navigation settings
        'navigation_saved' => 'Pengaturan navigasi berhasil disimpan!',
        'home_tab_cannot_delete' => 'Tab beranda tidak dapat dihapus. Diperlukan untuk navigasi.',
        'home_tab_cannot_move' => 'Tab beranda harus tetap pertama dan tidak dapat dipindahkan.',
        'cannot_move_below_home' => 'Tidak dapat memindahkan item di bawah tab beranda.',
        'home_item_cannot_delete' => 'Item beranda tidak dapat dihapus. Diperlukan untuk navigasi.',
        'home_item_cannot_move' => 'Item beranda harus tetap pertama dan tidak dapat dipindahkan.',
        'cannot_move_below_home_item' => 'Tidak dapat memindahkan item di bawah item beranda.',

        // Custom code
        'custom_code_saved' => 'Kode kustom berhasil disimpan!',
        'custom_code_save_failed' => 'Gagal menyimpan kode kustom. Silakan coba lagi.',
        'custom_code_no_access' => 'Paket Anda tidak termasuk akses kode kustom. Silakan upgrade paket Anda.',

        // WebView settings
        'webview_saved' => 'Pengaturan WebView berhasil disimpan!',

        // Permissions settings
        'permissions_saved' => 'Izin berhasil disimpan!',

        // Drawer settings
        'drawer_saved' => 'Pengaturan drawer berhasil disimpan!',

        // General settings
        'general_saved' => 'Pengaturan umum berhasil disimpan!',

        // Splashscreen settings
        'splashscreen_saved' => 'Pengaturan splashscreen berhasil disimpan!',

        // Icon settings
        'icon_uploaded' => 'Ikon aplikasi berhasil diunggah!',
        'icon_upload_failed' => 'Gagal mengunggah ikon: :error',
        'icon_removed' => 'Ikon aplikasi berhasil dihapus!',
        'icon_remove_failed' => 'Gagal menghapus ikon. Silakan coba lagi.',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'Gambar latar belakang splashscreen berhasil dihapus!',
        'splashscreen_background_delete_failed' => 'Gagal menghapus gambar latar belakang. Silakan coba lagi.',
        'splashscreen_logo_deleted' => 'Logo splashscreen berhasil dihapus!',
        'splashscreen_logo_delete_failed' => 'Gagal menghapus logo. Silakan coba lagi.',

        // Drawer modals
        'drawer_background_deleted' => 'Gambar latar belakang drawer berhasil dihapus!',
        'drawer_background_delete_failed' => 'Gagal menghapus gambar latar belakang. Silakan coba lagi.',
        'drawer_logo_deleted' => 'Logo drawer berhasil dihapus!',
        'drawer_logo_delete_failed' => 'Gagal menghapus logo. Silakan coba lagi.',
        'drawer_logo_light_deleted' => 'Logo mode terang drawer berhasil dihapus!',
        'drawer_logo_dark_deleted' => 'Logo mode gelap drawer berhasil dihapus!',

        // Notifications settings
        'notifications_saved' => 'Pengaturan notifikasi berhasil disimpan!',
        'firebase_credentials_deleted' => 'Kredensial Firebase berhasil dihapus!',
        'firebase_credentials_delete_failed' => 'Gagal menghapus kredensial Firebase. Silakan coba lagi.',
        'google_services_deleted' => 'File Google Services berhasil dihapus!',
        'google_services_delete_failed' => 'Gagal menghapus file Google Services. Silakan coba lagi.',

        // Signing keys
        'keystore_updated' => 'Keystore berhasil diperbarui!',
        'keystore_update_failed' => 'Gagal memperbarui keystore.',
        'keystore_load_failed' => 'Gagal memuat keystore.',
        'keystore_deleted' => 'Keystore berhasil dihapus!',
        'keystore_delete_failed' => 'Gagal menghapus keystore. Silakan coba lagi.',
        'keystore_uploaded' => 'Keystore berhasil diunggah!',
        'keystore_upload_failed' => 'Gagal mengunggah kunci penandatanganan: :error',
        'keystore_generated' => 'Keystore berhasil dihasilkan!',
        'keystore_set_default' => 'Keystore default berhasil diperbarui!',

        // Build modal
        'build_no_builders_platform' => 'Tidak ada builder tersedia untuk platform :platform. Silakan hubungi dukungan atau upgrade paket Anda.',
        'build_no_subscription' => 'Anda memerlukan langganan aktif untuk membangun aplikasi. Silakan berlangganan paket.',
        'build_no_builders_plan' => 'Tidak ada builder tersedia untuk paket Anda. Silakan hubungi dukungan atau upgrade paket Anda.',
        'build_builder_not_available' => 'Builder yang dipilih tidak tersedia untuk paket Anda.',
        'build_builder_unavailable' => 'Builder yang dipilih saat ini tidak tersedia.',
        'build_builder_no_platform' => 'Builder yang dipilih tidak mendukung platform :platform.',
        'build_insufficient_credits' => 'Kredit build tidak mencukupi. Build ini memerlukan :count kredit. Silakan upgrade paket Anda atau tunggu reset bulanan.',
        'build_keystore_required' => 'Keystore Android diperlukan untuk build rilis. Silakan pilih keystore.',
        'build_keystore_invalid' => 'Keystore yang dipilih tidak valid.',
        'build_already_in_progress' => 'Build :platform sudah dalam proses. Silakan tunggu hingga selesai.',
        'build_queued' => 'Build :platform berhasil ditambahkan ke antrian! Build Anda akan diproses saat builder tersedia. (:credits kredit tersisa)',
        'build_queued_on_builder' => 'Build :platform berhasil ditambahkan ke antrian di :builder! (:credits kredit tersisa)',
        'build_create_failed' => 'Gagal membuat build: :error',
        'build_deleted' => 'Build berhasil dihapus!',
        'build_delete_failed' => 'Gagal menghapus build. Silakan coba lagi.',

        // Hosted pages
        'hosted_page_saved' => 'Halaman berhasil disimpan!',
        'hosted_page_save_failed' => 'Gagal menyimpan halaman. Silakan coba lagi.',
        'hosted_page_deleted' => 'Halaman berhasil dihapus!',
        'hosted_page_delete_failed' => 'Gagal menghapus halaman. Silakan coba lagi.',
        'hosted_page_limit_reached' => 'Anda telah mencapai jumlah maksimum halaman hosted untuk paket Anda.',
        'hosted_page_no_access' => 'Paket Anda saat ini tidak termasuk halaman hosted. Upgrade paket Anda untuk membuat halaman kustom.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => 'Pengaturan fitur berhasil disimpan!',
        'content_saved' => 'Pengaturan konten berhasil disimpan!',
        'storage_link_missing' => 'Link storage tidak ditemukan. Jalankan: php artisan storage:link',
        'splashscreen_image_deleted' => 'Gambar latar belakang splashscreen berhasil dihapus!',
        'splashscreen_image_delete_failed' => 'Gagal menghapus gambar latar belakang. Silakan coba lagi.',
        'logo_delete_failed' => 'Gagal menghapus logo. Silakan coba lagi.',
        'default_key_updated' => 'Kunci penandatanganan default berhasil diperbarui!',
        'default_key_update_failed' => 'Gagal memperbarui kunci penandatanganan default.',
        'keystore_uploaded_default' => 'Keystore diunggah dan dijadikan default!',
        'signing_key_upload_failed' => 'Gagal mengunggah kunci penandatanganan: :error',
        'page_not_found' => 'Halaman tidak ditemukan.',
        'page_deleted' => 'Halaman berhasil dihapus!',
        'page_delete_failed' => 'Gagal menghapus halaman. Silakan coba lagi.',
        'page_updated' => 'Halaman berhasil diperbarui!',
        'page_created' => 'Halaman berhasil dibuat!',
        'page_save_failed' => 'Gagal menyimpan halaman. Silakan coba lagi.',
        'page_limit_reached' => 'Anda telah mencapai maksimum :max halaman untuk paket Anda.',
        'hosted_pages_not_available' => 'Paket Anda tidak termasuk halaman hosted. Silakan upgrade paket Anda.',
        'unauthorized' => 'Aksi tidak diizinkan.',
        'home_tab_required' => 'Tab beranda tidak dapat dihapus. Diperlukan untuk navigasi.',
        'home_tab_first' => 'Tab beranda harus tetap pertama.',
        'home_item_required' => 'Item beranda tidak dapat dihapus.',
        'build_no_builders' => 'Tidak ada builder tersedia untuk platform :platform. Silakan hubungi dukungan atau upgrade paket Anda.',
        'build_no_plan_builders' => 'Tidak ada builder tersedia untuk paket Anda. Silakan hubungi dukungan atau upgrade paket Anda.',
        'build_builder_platform_unsupported' => 'Builder yang dipilih tidak mendukung platform :platform.',
        'build_insufficient_credits' => 'Kredit build tidak mencukupi. Build ini memerlukan :credits kredit. Silakan upgrade paket Anda atau tunggu reset bulanan.',
        'build_invalid_keystore' => 'Keystore yang dipilih tidak valid.',
        'build_queued_no_builder' => 'Build :platform berhasil ditambahkan ke antrian! Build Anda akan diproses saat builder tersedia. (:credits kredit tersisa)',
        'build_queued_success' => 'Build :platform berhasil ditambahkan ke antrian di :builder! (:credits kredit tersisa)',
        'available_builder' => 'builder tersedia',
        'invalid_google_services_json' => 'File JSON tidak valid. Silakan unggah file google-services.json yang valid.',
        'invalid_google_services_structure' => 'google-services.json tidak valid. Bagian project_info atau client yang diperlukan tidak ada.',
        'invalid_firebase_service_account' => 'File JSON tidak valid. Silakan unggah file akun layanan Firebase yang valid.',
        'invalid_firebase_service_account_type' => 'File akun layanan Firebase tidak valid. Field tipe tidak ada atau tidak valid.',
        'settings_save_failed_error' => 'Gagal menyimpan pengaturan: :error',
        'file_delete_failed' => 'Gagal menghapus file: :error',
        'credentials_delete_failed' => 'Gagal menghapus kredensial: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => 'Umum',
        'general_description' => 'Informasi dasar dan pengaturan konfigurasi',
        'design' => 'Desain',
        'design_description' => 'Sesuaikan tata letak, warna, dan pengaturan tema',
        'icon' => 'Ikon',
        'icon_description' => 'Unggah ikon aplikasi untuk Android',
        'splashscreen' => 'Splashscreen',
        'splashscreen_description' => 'Konfigurasi tampilan dan animasi layar startup',
        'navigation' => 'Navigasi',
        'navigation_description' => 'Kelola item navigasi dan tombol app bar',
        'drawer' => 'Pengaturan Drawer',
        'drawer_description' => 'Sesuaikan tampilan dan branding menu drawer',
        'webview' => 'Pengaturan WebView',
        'webview_description' => 'Konfigurasi perilaku dan fitur WebView',
        'permissions' => 'Izin',
        'permissions_description' => 'Konfigurasi izin perangkat yang akan diminta aplikasi Anda',
        'custom_code' => 'Kode Kustom',
        'custom_code_description' => 'Injeksi CSS dan JavaScript kustom ke aplikasi Anda',
        'hosted_pages' => 'Halaman Hosted',
        'hosted_pages_description' => 'Buat halaman HTML kustom yang di-host oleh kami untuk aplikasi Anda',
        'pages' => 'Halaman',
        'add_page' => 'Tambah Halaman',
        'notifications' => 'Notifikasi',
        'notifications_description' => 'Konfigurasi Firebase Cloud Messaging untuk notifikasi',
        'builds' => 'Build',
        'builds_description' => 'Hasilkan file APK dan AAB Android untuk deployment',
        'credits' => 'Kredit',
        'new_build' => 'Build Baru',
        'signing' => 'Penandatanganan',
        'signing_description' => 'Kelola kunci penandatanganan untuk distribusi aplikasi',
        // WordPress-specific sections
        'general_description_wordpress' => 'Informasi dasar dan konfigurasi situs WordPress',
        'content' => 'Konten',
        'content_description' => 'Konfigurasi tampilan postingan dan pengaturan konten',
        'features' => 'Fitur',
        'features_description' => 'Aktifkan atau nonaktifkan fitur aplikasi',
    ],

];
