<?php

return [
    // Page Titles
    'admin_overview' => 'Tổng quan quản trị',
    'overview_title' => 'Tổng quan',
    'users_title' => 'Người dùng',
    'subscriptions_title' => 'Đăng ký',
    'transactions_title' => 'Giao dịch',
    'plans_title' => 'Gói dịch vụ',
    'builders_title' => 'Builders',
    'plugins_title' => 'Plugins',
    'languages_title' => 'Ngôn ngữ',
    'cronjobs_title' => 'Cron Jobs',
    'email_templates_title' => 'Mẫu email',
    'audit_logs_title' => 'Nhật ký kiểm toán',
    'settings_title' => 'Cài đặt',

    // Page Subtitles
    'users_subtitle' => 'Quản lý người dùng và tài khoản nền tảng',
    'subscriptions_subtitle' => 'Theo dõi đăng ký và thanh toán người dùng',
    'transactions_subtitle' => 'Xem và quản lý giao dịch thanh toán',
    'plans_subtitle' => 'Cấu hình gói đăng ký và giá cả',
    'builders_subtitle' => 'Quản lý builders để biên dịch ứng dụng',
    'plugins_subtitle' => 'Quản lý các plugins đã cài đặt',
    'languages_subtitle' => 'Quản lý các ngôn ngữ có sẵn',
    'cronjobs_subtitle' => 'Theo dõi các tác vụ đã lên lịch',
    'email_templates_subtitle' => 'Tùy chỉnh thông báo email gửi cho người dùng',
    'cronjobs_subtitle_full' => 'Theo dõi các tác vụ và tự động hóa đã lên lịch',
    'settings_subtitle_full' => 'Cấu hình cài đặt và tùy chọn toàn hệ thống',
    'search_settings' => 'Tìm kiếm cài đặt...',
    'no_settings_found' => 'Không tìm thấy cài đặt phù hợp',
    'system_settings' => 'Cài đặt hệ thống',
    'clear_search' => 'Xóa tìm kiếm',

    // Settings Sidebar Navigation
    'settings_section_general' => 'Tổng quan',
    'settings_section_plans' => 'Gói dịch vụ',
    'settings_section_auth' => 'Xác thực',
    'settings_section_email' => 'Email',
    'settings_section_privacy' => 'Quyền riêng tư',
    'settings_section_preview' => 'Xem trước',
    'settings_section_ai' => 'AI Chat',
    'settings_category_platform' => 'Nền tảng',
    'settings_category_security' => 'Bảo mật',
    'settings_category_integrations' => 'Tích hợp',
    'audit_logs_subtitle' => 'Theo dõi hành động người dùng và sự kiện hệ thống để tuân thủ GDPR',
    'no_audit_logs_found' => 'Không tìm thấy nhật ký kiểm toán.',
    'search_audit_logs' => 'Tìm theo người dùng, hành động, IP...',
    'date_time' => 'Ngày/Giờ',
    'actor' => 'Người thực hiện',
    'ip_address' => 'Địa chỉ IP',
    'details' => 'Chi tiết',
    'view_details' => 'Xem chi tiết',
    'system' => 'Hệ thống',
    'clear_filters' => 'Xóa bộ lọc',
    'to' => 'đến',
    'settings_subtitle' => 'Cấu hình cài đặt hệ thống',

    // Users
    'add_user' => 'Thêm người dùng',
    'edit_user' => 'Sửa người dùng',
    'create_user' => 'Tạo người dùng',
    'delete_user' => 'Xóa người dùng',
    'user_info' => 'Thông tin người dùng',
    'user_details' => 'Chi tiết người dùng',
    'no_users_found' => 'Không tìm thấy người dùng.',
    'search_users' => 'Tìm kiếm người dùng...',
    'user_role' => 'Vai trò',
    'user_plan' => 'Gói dịch vụ',
    'user_joined' => 'Ngày tham gia',
    'email_verified' => 'Email đã xác minh',
    'mark_email_verified' => 'Đánh dấu email đã xác minh',
    'role_admin' => 'Quản trị viên',
    'role_user' => 'Người dùng',
    'leave_blank_password' => 'Để trống để giữ mật khẩu hiện tại',

    // Plans
    'add_plan' => 'Thêm gói',
    'edit_plan' => 'Sửa gói',
    'create_plan' => 'Tạo gói',
    'create_new_plan' => 'Tạo gói mới',
    'update_plan' => 'Cập nhật gói',
    'delete_plan' => 'Xóa gói',
    'no_plans_found' => 'Không tìm thấy gói dịch vụ.',
    'plan_features' => 'Tính năng',
    'plan_price' => 'Giá',
    'plan_interval' => 'Chu kỳ thanh toán',
    'monthly' => 'Hàng tháng',
    'yearly' => 'Hàng năm',
    'default_plan' => 'Gói mặc định',
    'mark_as_default' => 'Đánh dấu là gói mặc định',
    'per_month' => '/tháng',
    'subscribers' => 'người đăng ký',
    'plan_name' => 'Tên gói',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => 'Thông tin cơ bản',
    'usage_limits' => 'Giới hạn sử dụng',
    'monthly_build_credits' => 'Tín dụng dựng hàng tháng',
    'unlimited' => 'Không giới hạn',
    'appetize_preview' => 'Xem trước Appetize',
    'hosted_pages' => 'Trang được lưu trữ',
    'ai_assistant' => 'Trợ lý AI',
    'allow_own_api_keys' => 'Cho phép dùng API key riêng',
    'permissions' => 'Quyền hạn',
    'custom_css_js_injection' => 'Chèn CSS/JS tùy chỉnh',
    'api_access' => 'Truy cập API',
    'builder_access' => 'Truy cập Builder',
    'all_builders_allowed' => 'Được phép tất cả builders',
    'select_builders' => 'Chọn builders',
    'builders_selected' => ':count builder được chọn|:count builders được chọn',
    'allow_all_builders' => 'Cho phép tất cả Builders',
    'search_builders_placeholder' => 'Tìm kiếm builders...',
    'features_pricing_display' => 'Tính năng (Hiển thị bảng giá)',
    'feature_name' => 'Tên tính năng',
    'included' => 'Bao gồm',
    'not_included' => 'Không bao gồm',
    'no_features_added' => 'Chưa có tính năng nào. Thêm tính năng để hiển thị trên trang giá.',

    // Subscriptions
    'add_subscription' => 'Thêm đăng ký',
    'subscription_details' => 'Chi tiết đăng ký',
    'no_subscriptions_found' => 'Không tìm thấy đăng ký.',
    'search_subscriptions' => 'Tìm kiếm đăng ký...',
    'renewal_date' => 'Ngày gia hạn',
    'subscription_status' => 'Trạng thái',
    'change_plan' => 'Đổi gói',
    'cancel_subscription' => 'Hủy đăng ký',
    'next_billing' => 'Thanh toán tiếp theo',
    'no_plan' => 'Không có gói',
    'select_user' => 'Chọn người dùng',
    'select_plan' => 'Chọn gói dịch vụ',
    'payment_method_placeholder' => 'Thủ công, Chuyển khoản ngân hàng, v.v.',

    // Transactions
    'transaction_details' => 'Chi tiết giao dịch',
    'no_transactions_found' => 'Không tìm thấy giao dịch.',
    'search_transactions' => 'Tìm kiếm giao dịch...',
    'transaction_id' => 'ID',
    'transaction_date' => 'Ngày',
    'transaction_amount' => 'Số tiền',
    'payment_method' => 'Phương thức thanh toán',
    'payment_gateway' => 'cổng thanh toán',
    'transaction_status' => 'Trạng thái',
    'approve' => 'Duyệt',
    'decline' => 'Từ chối',
    'confirm_approval' => 'Xác nhận duyệt',
    'confirm_decline' => 'Xác nhận từ chối',
    'approve_payment' => 'Duyệt thanh toán',
    'decline_payment' => 'Từ chối thanh toán',
    'approve_bank_transfer_confirm' => 'Bạn có chắc chắn muốn duyệt thanh toán chuyển khoản này? Điều này sẽ kích hoạt đăng ký của người dùng.',
    'decline_bank_transfer_confirm' => 'Bạn có chắc chắn muốn từ chối thanh toán chuyển khoản này? Điều này sẽ hủy đăng ký và thông báo cho người dùng.',

    // Builders
    'add_builder' => 'Thêm Builder',
    'edit_builder' => 'Sửa Builder',
    'create_builder' => 'Tạo Builder',
    'delete_builder' => 'Xóa Builder',
    'no_builders_found' => 'Không tìm thấy builder.',
    'search_builders' => 'Tìm kiếm builders...',
    'builder_name' => 'Tên Builder',
    'builder_url' => 'URL',
    'builder_status' => 'Trạng thái',
    'builder_platform' => 'Nền tảng',
    'builder_platforms' => 'Các nền tảng',
    'builder_name_placeholder' => 'Production Builder',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'Khóa máy chủ được tạo',
    'builder_queue' => 'Hàng đợi',
    'current_builds' => 'Bản dựng hiện tại',
    'total_builds' => 'Tổng bản dựng',
    'server_url' => 'URL máy chủ',
    'port' => 'Cổng',
    'server_key' => 'Khóa máy chủ',
    'server_key_help' => 'Dùng để xác thực yêu cầu API đến builder này',
    'generate' => 'Tạo',
    'max_queue' => 'Hàng đợi tối đa',
    'max_queue_help' => 'Số bản dựng đồng thời tối đa',
    'build_credit_cost' => 'Chi phí tín dụng dựng',
    'credit_cost_help' => 'Tín dụng trừ mỗi bản dựng',
    'supported_platforms' => 'Nền tảng hỗ trợ',
    'select_platforms' => 'Chọn nền tảng',
    'platforms_selected' => ':count nền tảng được chọn|:count nền tảng được chọn',
    'platforms_help' => 'Chọn một hoặc nhiều nền tảng builder này hỗ trợ',
    'no_platforms_available' => 'Không có nền tảng nào',
    'no_builders_configured' => 'Chưa cấu hình builder nào.',
    'default' => 'Mặc định',
    'locked' => 'Đã khóa',
    'from_purchase_code' => 'Từ mã mua hàng',
    'purchase_code_not_set_warning' => 'Chưa cấu hình mã mua hàng',
    'purchase_code_not_set_description' => 'Builder mặc định yêu cầu mã mua hàng hợp lệ. Vui lòng cấu hình trong Cài đặt > Tổng quan.',
    'server_key_from_purchase_code_help' => 'Khóa máy chủ được tự động đặt từ mã mua hàng của bạn.',

    // Plugins
    'upload_plugin' => 'Tải lên Plugin',
    'configure_plugin' => 'Cấu hình',
    'delete_plugin' => 'Xóa Plugin',
    'no_plugins_found' => 'Không tìm thấy plugin.',
    'plugin_name' => 'Tên',
    'plugin_version' => 'Phiên bản',
    'plugin_type' => 'Loại',
    'plugin_status' => 'Trạng thái',

    // Languages
    'add_language' => 'Thêm ngôn ngữ',
    'add_new_language' => 'Thêm ngôn ngữ mới',
    'edit_language' => 'Sửa ngôn ngữ',
    'create_language' => 'Tạo ngôn ngữ',
    'delete_language' => 'Xóa ngôn ngữ',
    'no_languages_found' => 'Không tìm thấy ngôn ngữ.',
    'cannot_delete_default_language' => 'Không thể xóa ngôn ngữ mặc định hoặc chính.',
    'default_language_badge' => 'Mặc định',
    'language_name' => 'Tên ngôn ngữ',
    'language_code' => 'Mã ngôn ngữ',
    'language_code_help' => 'Mã ISO 639-1 2 ký tự (ví dụ: en, es, fr)',
    'language_code_from_folder' => 'Chọn từ các thư mục dịch có sẵn',
    'language_flag' => 'Cờ',
    'language_flag_help' => 'Emoji cờ quốc gia',
    'language_flag_auto' => 'Cờ được tự động đặt dựa trên mã ngôn ngữ',
    'language_flag_country_code_help' => 'Mã quốc gia 2 ký tự (ví dụ: us, gb, es)',
    'language_name_placeholder' => 'Tiếng Anh',
    'language_code_placeholder' => 'en',
    'language_flag_placeholder' => '🇺🇸',
    'language_status' => 'Trạng thái',
    'rtl_support' => 'Hướng văn bản',
    'rtl_enabled' => 'Phải sang trái (RTL)',
    'rtl_description' => 'Bật cho các ngôn ngữ như tiếng Ả Rập, Hebrew, Ba Tư và Urdu',
    'translation_files_created' => 'Các tệp dịch sẽ được tạo tại: lang/:code/',
    'translation_files_auto_created' => 'Đảm bảo các tệp dịch tồn tại trong :path trước khi thêm ngôn ngữ này. Sao chép thư mục lang/en/, đổi tên thành mã ngôn ngữ của bạn và dịch nội dung.',

    // Email Templates
    'edit_template' => 'Sửa mẫu',
    'edit_email_template' => 'Sửa mẫu email',
    'reset_template' => 'Đặt lại về mặc định',
    'no_templates_found' => 'Không tìm thấy mẫu.',
    'template_subject' => 'Chủ đề',
    'template_body' => 'Nội dung',
    'template_variables' => 'Biến có sẵn',
    'subject_line' => 'Dòng chủ đề',
    'email_subject_placeholder' => 'Chủ đề email...',
    'email_body' => 'Nội dung email',
    'click_to_insert' => 'Nhấp để chèn vào vị trí con trỏ',
    'no_variables_available' => 'Không có biến nào cho mẫu này.',
    'quick_tips' => 'Mẹo nhanh',
    'variables_replaced' => 'Các biến được thay thế bằng dữ liệu thực khi gửi',
    'toolbar_format_tip' => 'Sử dụng thanh công cụ để định dạng văn bản, thêm liên kết và tạo danh sách',
    'link_tip' => 'Chọn văn bản và nhấp nút liên kết để thêm liên kết có thể nhấp',

    // Cronjobs
    'no_cronjobs_found' => 'Không tìm thấy cron job.',
    'no_cron_logs_found' => 'Không tìm thấy nhật ký cron.',
    'search_logs' => 'Tìm kiếm nhật ký...',
    'job_name' => 'Tên Job',
    'job' => 'Job',
    'last_run' => 'Chạy lần cuối',
    'next_run' => 'Chạy tiếp theo',
    'run_duration' => 'Thời lượng',
    'started' => 'Bắt đầu',
    'duration' => 'Thời lượng',
    'triggered_by' => 'Kích hoạt bởi',
    'message' => 'Thông báo',
    'all_jobs' => 'Tất cả Jobs',
    'trigger_manually' => 'Kích hoạt thủ công',
    'status_success' => 'Thành công',
    'status_running' => 'Đang chạy',

    // Settings
    'general_settings' => 'Cài đặt chung',
    'email_settings' => 'Cài đặt email',
    'social_login_settings' => 'Đăng nhập mạng xã hội',
    'appetize_settings' => 'Cài đặt Appetize',
    'ai_settings' => 'Cài đặt AI',
    'gdpr_settings' => 'Cài đặt GDPR',

    // General Settings Fields
    'site_name' => 'Tên trang web',
    'site_description' => 'Mô tả trang web',
    'site_tagline' => 'Khẩu hiệu trang web',
    'logo' => 'Logo',
    'logo_dark' => 'Logo chế độ tối',
    'favicon' => 'Favicon',
    'default_theme' => 'Chủ đề mặc định',
    'landing_page_enabled' => 'Bật trang đích',
    'system_currency' => 'Tiền tệ hệ thống',
    'default_language' => 'Ngôn ngữ mặc định',
    'default_language_description' => 'Ngôn ngữ mặc định cho khách mới và người dùng không có tùy chọn',

    // Status Labels
    'status_active' => 'Hoạt động',
    'status_inactive' => 'Không hoạt động',
    'status_pending' => 'Đang chờ',
    'status_expired' => 'Hết hạn',
    'status_cancelled' => 'Đã hủy',
    'status_completed' => 'Hoàn thành',
    'status_failed' => 'Thất bại',

    // Demo Mode
    'demo_mode_notice' => 'Không thể sửa đổi cài đặt trong chế độ demo.',
    'disabled_in_demo' => 'Đã tắt trong chế độ demo',
    'hidden_in_demo' => 'Ẩn trong chế độ demo',

    // Plugins
    'plugins_title_full' => 'Plugins',
    'plugins_subtitle_full' => 'Mở rộng chức năng với các plugin tùy chỉnh',
    'no_plugins_installed' => 'Chưa cài đặt plugin nào',
    'plugin_activate' => 'Kích hoạt',
    'plugin_deactivate' => 'Vô hiệu hóa',
    'plugin_uninstall' => 'Gỡ cài đặt',
    'plugin_author' => 'bởi :author',

    // Languages
    'languages_title_full' => 'Ngôn ngữ',
    'languages_subtitle_full' => 'Quản lý bản dịch và địa phương hóa',

    // Cronjobs
    'cronjobs_title_full' => 'Cron Jobs',
    'cronjobs_tab_jobs' => 'Jobs đã lên lịch',
    'cronjobs_tab_logs' => 'Nhật ký thực thi',
    'execute_job' => 'Thực thi',
    'executing_job' => 'Đang thực thi...',

    // Email Settings
    'email_config_title' => 'Cấu hình email',
    'email_config_subtitle' => 'Cấu hình cài đặt email và máy chủ SMTP',
    'mail_driver' => 'Trình điều khiển mail',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail sử dụng cấu hình mail tích hợp của máy chủ. Đơn giản nhưng có thể gặp vấn đề gửi trên một số máy chủ.',
    'php_mail_warning' => 'Lưu ý: Một số nhà cung cấp hosting vô hiệu hóa hàm mail() của PHP. Nếu email không được gửi, hãy cân nhắc chuyển sang SMTP.',
    'smtp_config' => 'Cấu hình máy chủ SMTP',
    'smtp_host' => 'Host SMTP',
    'smtp_port' => 'Cổng SMTP',
    'smtp_username' => 'Tên đăng nhập SMTP',
    'smtp_password' => 'Mật khẩu SMTP',
    'smtp_encryption' => 'Mã hóa',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'Không',
    'admin_notifications' => 'Thông báo quản trị',
    'admin_email' => 'Email thông báo quản trị',
    'admin_email_help' => 'Địa chỉ email nhận thông báo quản trị. Nếu trống, email của quản trị viên đang đăng nhập sẽ được sử dụng.',
    'notify_user_registered' => 'Người dùng mới đăng ký',
    'notify_subscription_created' => 'Đăng ký mới được tạo',
    'notify_subscription_cancelled' => 'Đăng ký bị hủy',
    'notify_payment_received' => 'Nhận thanh toán',
    'notify_payment_failed' => 'Thanh toán thất bại',
    'notify_build_started' => 'Bản dựng bắt đầu',
    'notify_build_completed' => 'Bản dựng hoàn thành',
    'notify_build_failed' => 'Bản dựng thất bại',
    'test_email' => 'Email thử nghiệm',
    'send_test_email' => 'Gửi email thử nghiệm',
    'sending' => 'Đang gửi...',
    'mail_from_name' => 'Tên người gửi',
    'mail_from_address' => 'Địa chỉ người gửi',
    'php_mail_info' => 'PHP Mail sử dụng cấu hình mail tích hợp của máy chủ (sendmail/postfix). Không cần thiết lập thêm trong bảng điều khiển này.',
    'php_mail_switch_warning' => 'Lưu ý: Một số nhà cung cấp hosting vô hiệu hóa hàm mail() của PHP. Nếu email không gửi được, hãy chuyển sang SMTP.',
    'admin_notifications_subtitle' => 'Cấu hình nơi gửi thông báo thanh toán quản trị',
    'admin_email_description' => 'Địa chỉ email nhận thông báo quản trị. Cũng được sử dụng cho email thử nghiệm.',
    'notification_events' => 'Sự kiện thông báo',
    'notification_events_description' => 'Chọn sự kiện nào sẽ kích hoạt thông báo quản trị',
    'event_subscription_activated' => 'Đăng ký được kích hoạt',
    'event_payment_completed' => 'Thanh toán hoàn thành',
    'event_payment_failed' => 'Thanh toán thất bại',
    'event_subscription_cancelled' => 'Đăng ký bị hủy',
    'event_subscription_expired' => 'Đăng ký hết hạn',
    'event_bank_transfer_pending' => 'Chuyển khoản ngân hàng đang chờ',
    'event_user_registered' => 'Người dùng đăng ký',
    'event_build_completed' => 'Bản dựng hoàn thành',
    'event_build_failed' => 'Bản dựng thất bại',

    // Social Login Settings
    'auth_settings_title' => 'Cài đặt xác thực',
    'auth_settings_subtitle' => 'Cấu hình đăng ký và tùy chọn đăng nhập mạng xã hội',
    'enable_registration' => 'Bật đăng ký',
    'enable_registration_description' => 'Cho phép người dùng mới đăng ký tài khoản',
    'require_email_verification' => 'Yêu cầu xác minh email',
    'require_email_verification_description' => 'Khi tắt, đăng ký mới sẽ tự động được xác minh',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'Bảo vệ form xác thực khỏi bot',
    'recaptcha_site_key' => 'Site Key',
    'recaptcha_site_key_placeholder' => 'reCAPTCHA v3 Site Key của bạn',
    'recaptcha_secret_key' => 'Secret Key',
    'recaptcha_secret_key_placeholder' => 'reCAPTCHA v3 Secret Key của bạn',
    'leave_blank_keep_current' => 'Để trống để giữ nguyên',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'Client ID',
    'client_id_placeholder' => ':provider Client ID của bạn',
    'client_secret' => 'Client Secret',
    'client_secret_placeholder' => ':provider Client Secret của bạn',
    'app_id' => 'App ID',
    'app_id_placeholder' => ':provider App ID của bạn',
    'app_secret' => 'App Secret',
    'app_secret_placeholder' => ':provider App Secret của bạn',
    'callback_url' => 'URL Callback',
    'oauth_help' => 'Tạo thông tin OAuth trong :provider Developer Console. Sử dụng URL callback ở trên.',
    'test_connection' => 'Kiểm tra kết nối',
    'testing' => 'Đang kiểm tra...',
    'configure_oauth' => 'Cấu hình thông tin OAuth :provider',
    'add_url_to_console' => 'Thêm URL này vào :provider của bạn',
    'your_provider_key' => ':provider :type của bạn',
    'recaptcha_help' => 'Lấy khóa từ :link. Đảm bảo chọn reCAPTCHA v3.',
    'recaptcha_console' => 'Google reCAPTCHA Admin Console',
    'get_api_key_from' => 'Lấy API key từ :link',

    // General Settings
    'general_settings_title' => 'Cài đặt chung',
    'general_settings_subtitle' => 'Cập nhật thông tin và thương hiệu trang web',
    'site_name_label' => 'Tên trang web',
    'site_description_label' => 'Mô tả trang web',
    'site_description_placeholder' => 'Dùng cho mô tả meta và SEO',
    'site_tagline_label' => 'Khẩu hiệu trang web',
    'site_tagline_placeholder' => 'Khẩu hiệu ngắn hiển thị bên dưới logo',
    'site_tagline_help' => 'Hiển thị bên dưới logo trong thanh bên và trang đăng nhập',
    'purchase_code_label' => 'Mã mua hàng',
    'purchase_code_help' => 'Mã giấy phép hoặc mua hàng cho cài đặt này (tùy chọn)',
    'logo_light' => 'Logo (Chế độ sáng)',
    'logo_dark_label' => 'Logo (Chế độ tối)',
    'delete_logo' => 'Xóa Logo',
    'delete_dark_logo' => 'Xóa Logo tối',
    'delete_favicon' => 'Xóa Favicon',
    'logo_help' => 'Khuyến nghị: 200x50px (ngang) hoặc 50x50px (vuông). PNG, JPG, SVG với nền trong suốt. Tối đa 2MB.',
    'favicon_label' => 'Favicon',
    'favicon_help' => 'Khuyến nghị: 32x32px hoặc 16x16px. PNG, ICO hoặc SVG. Tối đa 1MB.',
    'default_theme_label' => 'Chủ đề màu mặc định',
    'theme_system' => 'Hệ thống (Theo tùy chọn thiết bị người dùng)',
    'theme_light' => 'Sáng',
    'theme_dark' => 'Tối',
    'theme_help' => 'Chủ đề mặc định cho khách mới. Người dùng có thể thay đổi trong cài đặt.',
    'currency_label' => 'Tiền tệ hệ thống',
    'currency_help' => 'Tiền tệ sử dụng cho tất cả giá và thanh toán. Điều này xác định cổng thanh toán nào có sẵn.',
    'landing_page_toggle' => 'Bật trang đích công khai',
    'landing_page_help' => 'Khi tắt, khách truy cập URL gốc (/) sẽ được chuyển hướng đến trang đăng nhập',

    // Plan Configuration Settings
    'plan_config_title' => 'Cấu hình gói dịch vụ',
    'plan_config_subtitle' => 'Cấu hình cài đặt gói mặc định cho người dùng mới',
    'default_plan_label' => 'Gói mặc định',
    'default_plan_none' => 'Không (yêu cầu đăng ký)',
    'default_plan_help' => 'Gói được gán cho người dùng mới khi đăng ký. Nếu không chọn gói, người dùng sẽ cần đăng ký để truy cập tính năng.',

    // AI Settings
    'ai_settings_title' => 'Trợ lý AI Chat',
    'ai_settings_subtitle' => 'Cấu hình trợ lý tạo ứng dụng được hỗ trợ bởi AI',
    'enable_ai' => 'Bật trợ lý AI Chat',
    'enable_ai_description' => 'Cho phép người dùng tạo và cấu hình ứng dụng qua hội thoại AI',
    'enable_streaming' => 'Bật phản hồi streaming',
    'enable_streaming_description' => 'Stream phản hồi AI từng từ để có trải nghiệm tương tác hơn',
    'streaming_warning' => 'Có thể không hoạt động trên tất cả môi trường hosting chia sẻ',
    'ai_provider' => 'Nhà cung cấp AI',
    'ai_provider_help' => 'Chọn giữa OpenAI (GPT-4.1) hoặc Anthropic (Claude)',
    'api_key' => 'API Key',
    'enter_api_key' => 'Nhập API key của bạn',
    'openai_console' => 'bảng điều khiển OpenAI',
    'anthropic_console' => 'bảng điều khiển Anthropic',
    'api_key_help' => 'Lấy API key từ :provider',
    'advanced_settings' => 'Cài đặt nâng cao',
    'ai_model' => 'Mô hình AI',
    'ai_model_help' => 'Chọn mô hình AI để sử dụng cho phản hồi chat',
    'temperature' => 'Nhiệt độ',
    'temperature_help' => 'Kiểm soát tính ngẫu nhiên. Thấp hơn = tập trung hơn, Cao hơn = sáng tạo hơn',
    'max_tokens' => 'Token phản hồi tối đa',
    'max_tokens_help' => 'Token tối đa cho mỗi phản hồi AI. Giá trị cao hơn = phản hồi dài hơn nhưng tốn kém hơn',
    'auto_summarization' => 'Tự động tóm tắt',
    'enable_summarization' => 'Bật tự động tóm tắt',
    'summarization_help' => 'Tự động tóm tắt tin nhắn cũ để giảm sử dụng token trong cuộc hội thoại dài',
    'summarization_threshold' => 'Ngưỡng tóm tắt',
    'summarization_threshold_help' => 'Số tin nhắn trước khi kích hoạt tự động tóm tắt',
    'summarization_keep_recent' => 'Giữ tin nhắn gần đây',
    'summarization_keep_recent_help' => 'Số tin nhắn gần đây cần giữ',
    'summarization_max_length' => 'Độ dài tóm tắt tối đa',
    'summarization_max_length_help' => 'Số ký tự tối đa cho tóm tắt',
    'chat_widget' => 'Widget Chat',
    'widget_position' => 'Vị trí Widget',
    'position_bottom_right' => 'Dưới phải',
    'position_bottom_left' => 'Dưới trái',
    'position_top_right' => 'Trên phải',
    'position_top_left' => 'Trên trái',
    'position_help' => 'Nơi widget AI chat xuất hiện trên trang chỉnh sửa ứng dụng',

    // GDPR Settings
    'gdpr_settings_title' => 'Cài đặt GDPR',
    'gdpr_settings_subtitle' => 'Cấu hình tuân thủ GDPR và cài đặt quyền riêng tư',
    'enable_cookie_consent' => 'Bật banner đồng ý cookie',
    'enable_data_export' => 'Bật xuất dữ liệu',
    'enable_account_deletion' => 'Bật xóa tài khoản',
    'deletion_grace_period' => 'Thời gian ân hạn xóa tài khoản (ngày)',
    'audit_log_retention' => 'Lưu giữ nhật ký kiểm toán (ngày)',

    // Appetize Settings
    'appetize_settings_title' => 'Cài đặt Appetize',
    'appetize_settings_subtitle' => 'Cấu hình Appetize.io cho xem trước ứng dụng trực tiếp',
    'appetize_api_token' => 'Appetize API Token',
    'appetize_api_token_help' => 'Lấy API token từ bảng điều khiển Appetize.io của bạn',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'Bạn có chắc chắn muốn xóa',
    'delete_builder_confirm' => 'Bạn có chắc chắn muốn xóa',
    'delete_plan_confirm' => 'Bạn có chắc chắn muốn xóa gói',
    'delete_plan_confirm_suffix' => '?',
    'delete_language_confirm' => 'Bạn có chắc chắn muốn xóa',
    'delete_language_note' => 'Hành động này không thể hoàn tác. Các tệp dịch sẽ được giữ lại để bảo mật dữ liệu.',
    'uninstall_plugin' => 'Gỡ cài đặt Plugin',
    'uninstall_plugin_confirm' => 'Bạn có chắc chắn muốn gỡ cài đặt',
    'cancel_subscription_confirm' => 'Bạn có chắc chắn muốn hủy đăng ký của',
    'reset_email_template' => 'Đặt lại mẫu email',
    'reset_template_confirm' => 'Bạn có chắc chắn muốn đặt lại',
    'reset_template_confirm_suffix' => 'về nội dung mặc định?',
    'reset_template_warning' => 'Mọi tùy chỉnh bạn đã thực hiện sẽ bị mất.',
    'disabled_in_demo' => 'Đã tắt trong chế độ demo',

    // Plugin Upload Modal
    'plugin_file' => 'Tệp Plugin',
    'plugin_file_help' => 'Tệp ZIP (TỐI ĐA 10MB)',
    'installing_plugin' => 'Đang cài đặt plugin...',
    'installing' => 'Đang cài đặt...',

    // Plugin Config Modal
    'configure_plugin_title' => 'Cấu hình :name',
    'no_config_required' => 'Không cần cấu hình',
    'no_config_required_desc' => 'Plugin này không yêu cầu cấu hình nào.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Tích hợp Appetize.io',
    'appetize_integration_subtitle' => 'Cấu hình chức năng xem trước ứng dụng trực tiếp',
    'enable_appetize_integration' => 'Bật tích hợp Appetize.io',
    'enable_appetize_description' => 'Cho phép người dùng gói Pro/Enterprise xem trước ứng dụng trong trình duyệt',
    'appetize_api_token_placeholder' => 'Nhập Appetize.io API token của bạn',
    'appetize_api_token_link' => 'Lấy API token từ',
    'auto_upload_builds' => 'Tự động tải bản dựng lên Appetize',
    'auto_upload_description' => 'Tự động tải các bản dựng thành công để xem trước ngay',
    'preview_retention_days' => 'Thời gian lưu giữ xem trước (Ngày)',
    'preview_retention_help' => 'Xóa bản xem trước cũ sau số ngày này để tiết kiệm chi phí (1-30 ngày)',
    'session_timeout_seconds' => 'Thời gian chờ phiên (Giây)',
    'session_timeout_help' => 'Thời gian không hoạt động trước khi phiên kết thúc',
    'seconds_30' => '30 giây',
    'minute_1' => '1 phút',
    'minutes_2' => '2 phút',
    'minutes_3' => '3 phút',
    'minutes_5' => '5 phút',
    'minutes_10' => '10 phút',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'Cài đặt GDPR & Quyền riêng tư',
    'gdpr_privacy_settings_subtitle' => 'Cấu hình tuân thủ bảo vệ dữ liệu và quyền riêng tư',
    'feature_toggles' => 'Bật/Tắt tính năng',
    'cookie_consent_banner' => 'Banner đồng ý Cookie',
    'cookie_consent_description' => 'Hiển thị banner đồng ý cookie cho khách mới',
    'user_data_export' => 'Xuất dữ liệu người dùng',
    'user_data_export_description' => 'Cho phép người dùng yêu cầu bản sao dữ liệu của họ',
    'user_account_deletion' => 'Xóa tài khoản người dùng',
    'user_account_deletion_description' => 'Cho phép người dùng yêu cầu xóa tài khoản',
    'policy_versions' => 'Phiên bản chính sách',
    'policy_versions_help' => 'Cập nhật phiên bản chính sách sẽ yêu cầu người dùng đồng ý lại.',
    'privacy_policy' => 'Chính sách bảo mật',
    'terms_of_service' => 'Điều khoản dịch vụ',
    'cookie_policy' => 'Chính sách Cookie',
    'data_retention_periods' => 'Thời gian lưu giữ dữ liệu (Ngày)',
    'retention_transactions' => 'Giao dịch',
    'retention_transactions_help' => 'Tối thiểu 365 ngày (yêu cầu pháp lý)',
    'retention_inactive_accounts' => 'Tài khoản không hoạt động',
    'retention_expired_builds' => 'Bản dựng hết hạn',
    'retention_audit_logs' => 'Nhật ký kiểm toán',
    'retention_data_exports' => 'Xuất dữ liệu',
    'grace_periods_rate_limits' => 'Thời gian ân hạn & Giới hạn tần suất',
    'account_deletion_grace_period' => 'Thời gian ân hạn xóa tài khoản (Ngày)',
    'account_deletion_grace_help' => 'Thời gian trước khi tài khoản bị xóa vĩnh viễn',
    'data_export_rate_limit' => 'Giới hạn tần suất xuất dữ liệu (Giờ)',
    'data_export_rate_limit_help' => 'Thời gian tối thiểu giữa các yêu cầu xuất',

    // App/Plan Settings
    'plan_configuration' => 'Cấu hình gói dịch vụ',
    'plan_configuration_subtitle' => 'Cấu hình cài đặt gói mặc định cho người dùng mới',
    'default_plan_option_none' => 'Không (yêu cầu đăng ký)',
    'default_plan_description' => 'Gói được gán cho người dùng mới. Chọn "Không" để yêu cầu đăng ký trước khi sử dụng.',

    // Overview Stats
    'overview_subtitle' => 'Thống kê toàn hệ thống và số liệu quản trị',
    'date_range_today' => 'Hôm nay',
    'date_range_week' => 'Tuần',
    'date_range_month' => 'Tháng',
    'date_range_year' => 'Năm',
    'date_range_all' => 'Tất cả',
    'auto_refresh' => 'Tự động làm mới',
    'total_system_users' => 'Tổng người dùng hệ thống',
    'active_subscriptions' => 'Đăng ký đang hoạt động',
    'revenue_label' => 'Doanh thu :period',
    'total_apps' => 'Tổng ứng dụng',
    'vs_last_month' => 'so với tháng trước',
    'total_builds_stat' => 'Tổng bản dựng',
    'completed_today' => 'Hoàn thành hôm nay',
    'build_success_rate' => 'Tỷ lệ thành công bản dựng',
    'pending_queue' => 'Hàng đợi đang chờ',
    'total_transactions' => 'Tổng giao dịch',
    'active_plans' => 'Gói đang hoạt động',
    'active_builders' => 'Builders đang hoạt động',
    'revenue_trends' => 'Xu hướng doanh thu (12 tháng)',
    'build_activity' => 'Hoạt động bản dựng (30 ngày qua)',
    'revenue_by_gateway' => 'Doanh thu theo cổng thanh toán',
    'no_revenue_data' => 'Chưa có dữ liệu doanh thu',
    'total_revenue' => 'Tổng doanh thu',
    'platform_distribution' => 'Phân bố nền tảng',
    'no_apps_created' => 'Chưa có ứng dụng nào được tạo',
    'pending_payments' => 'Thanh toán đang chờ',
    'active_users_7d' => 'Người dùng hoạt động (7 ngày)',
    'notifications_today' => 'Thông báo (Hôm nay)',
    'build_performance_by_platform' => 'Hiệu suất bản dựng theo nền tảng',
    'platform' => 'Nền tảng',
    'completed' => 'Hoàn thành',
    'failed' => 'Thất bại',
    'success_rate' => 'Tỷ lệ thành công',
    'avg_duration' => 'Thời gian TB',
    'revenue_label_short' => 'Doanh thu',
    'builds_label' => 'Bản dựng',
    'recent_user_registrations' => 'Đăng ký người dùng gần đây',
    'no_users_yet' => 'Chưa có người dùng',
    'recent_builds' => 'Bản dựng gần đây',
    'no_builds_yet' => 'Chưa có bản dựng',
    'recent_transactions' => 'Giao dịch gần đây',
    'no_transactions_yet' => 'Chưa có giao dịch',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'Jobs',
    'cronjobs_tab_execution_logs' => 'Nhật ký thực thi',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'Thông tin API',
        'webhook_configuration' => 'Cấu hình Webhook',
        'webhook_url' => 'URL Webhook',
        'copy' => 'Sao chép',
        'copied' => 'Đã sao chép!',
        'copy_failed' => 'Không thể sao chép. Vui lòng chọn và sao chép URL thủ công.',
        'required_webhook_events' => 'Sự kiện Webhook bắt buộc',
        'features' => 'Tính năng',
        'supported_features' => 'Tính năng hỗ trợ',
        'secret_key' => 'Secret Key',
        'webhook_secret' => 'Webhook Secret',
        'webhook_signing_secret' => 'Webhook Signing Secret',
        'optional' => 'Tùy chọn',

        // SSL Warning
        'ssl_warning' => 'Cảnh báo:',
        'ssl_warning_stripe' => 'Trang web của bạn không sử dụng HTTPS. Stripe yêu cầu HTTPS cho webhooks và sử dụng production.',
        'ssl_warning_paypal' => 'Trang web của bạn không sử dụng HTTPS. PayPal webhooks yêu cầu kết nối HTTPS an toàn. Vui lòng bật SSL/TLS trước khi hoạt động.',
        'ssl_warning_paystack' => 'Trang web của bạn không sử dụng HTTPS. Paystack webhooks yêu cầu kết nối HTTPS an toàn. Vui lòng bật SSL/TLS trước khi hoạt động.',

        // Stripe
        'stripe' => [
            'get_started' => 'Bắt đầu với Stripe',
            'get_api_keys' => 'Lấy API keys từ',
            'dashboard_link' => 'Stripe Dashboard → Developers → API Keys',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'Sử dụng test key (sk_test_) để thử nghiệm, live key (sk_live_) cho production',
            'webhook_url_help' => 'Thêm URL này vào Stripe Dashboard → Developers → Webhooks',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Lấy sau khi tạo webhook endpoint trong Stripe Dashboard',
            'events_help' => 'Chọn các sự kiện này khi tạo webhook endpoint:',
            'feature_currencies' => 'Hỗ trợ hơn 135 loại tiền tệ toàn cầu',
            'feature_intervals' => 'Hỗ trợ tất cả chu kỳ thanh toán',
            'feature_renewal' => 'Tự động gia hạn đăng ký',
            'feature_customer_management' => 'Quản lý khách hàng',
            'feature_signature_verification' => 'Xác minh chữ ký webhook',
            'feature_refund' => 'Xử lý hoàn tiền',
            'feature_sca' => 'Tuân thủ Xác thực khách hàng mạnh (SCA)',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'Client ID',
            'client_id_help' => 'Lấy từ PayPal Developer Dashboard',
            'client_secret' => 'Client Secret',
            'client_secret_help' => 'Giữ bí mật và không chia sẻ công khai',
            'sandbox_mode' => 'Chế độ Sandbox',
            'sandbox_mode_help' => 'Bật để thử nghiệm với PayPal Sandbox. Tắt cho giao dịch thực.',
            'webhook_url_help' => 'Thêm URL này vào cài đặt webhook PayPal của bạn',
            'webhook_id' => 'Webhook ID',
            'webhook_id_help' => 'Webhook ID từ PayPal Dashboard để xác minh chữ ký (bắt buộc cho bảo mật)',
            'events_help' => 'Đảm bảo bật các sự kiện này trong cấu hình webhook PayPal:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Bắt đầu với Razorpay',
            'get_api_keys' => 'Lấy API keys từ',
            'dashboard_link' => 'Razorpay Dashboard → Settings → API Keys',
            'key_id' => 'Key ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'Sử dụng test key (rzp_test_) để thử nghiệm, live key (rzp_live_) cho production',
            'key_secret' => 'Key Secret',
            'key_secret_help' => 'Giữ bí mật và không chia sẻ công khai',
            'webhook_url_help' => 'Thêm URL này vào Razorpay Dashboard → Settings → Webhooks',
            'webhook_secret_placeholder' => 'Nhập webhook secret',
            'webhook_secret_help' => 'Lấy từ Razorpay Dashboard sau khi tạo webhook',
            'events_help' => 'Bật các sự kiện này trong Razorpay Dashboard → Settings → Webhooks:',
            'feature_currencies' => 'Hỗ trợ hơn 100 loại tiền tệ',
            'feature_intervals' => 'Tất cả chu kỳ thanh toán (hàng ngày, hàng tuần, hàng tháng, hàng năm)',
            'feature_payment_methods' => 'UPI, Thẻ, NetBanking, Ví, EMI',
            'feature_renewal' => 'Tự động gia hạn đăng ký',
            'feature_signature_verification' => 'Xác minh chữ ký webhook',
            'feature_refund' => 'Xử lý hoàn tiền',
            'feature_decimal' => 'Hỗ trợ tiền tệ ba chữ số thập phân (KWD, BHD, v.v.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Bắt đầu với Paystack',
            'get_api_keys' => 'Lấy API keys từ',
            'dashboard_link' => 'Paystack Dashboard → Settings → API Keys & Webhooks',
            'secret_key_help' => 'Lấy từ Paystack Dashboard (sử dụng test key để thử nghiệm, live key cho production)',
            'webhook_url_help' => 'Thêm URL này vào cài đặt webhook Paystack của bạn',
            'webhook_secret_help' => 'Tùy chọn: Để xác minh chữ ký webhook (khuyến nghị cho production)',
            'webhook_secret_placeholder' => 'Để trống để bỏ qua xác minh chữ ký',
            'events_help' => 'Bật các sự kiện này trong Paystack Dashboard → Settings → API Keys & Webhooks:',
            'feature_currencies' => 'Tiền tệ: NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => 'Chu kỳ: Hàng ngày, Hàng tuần, Hàng tháng (1, 3, 6 tháng), Hàng năm',
            'feature_renewal' => 'Tự động gia hạn đăng ký',
            'feature_signature_verification' => 'Xác minh chữ ký webhook',
            'feature_interval_limitation' => 'Hỗ trợ chu kỳ giới hạn (xem tài liệu)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Bắt đầu với Crypto.com Pay',
            'get_api_keys' => 'Lấy thông tin API từ',
            'dashboard_link' => 'Crypto.com Pay Dashboard',
            'monthly_only_title' => 'Chỉ chu kỳ hàng tháng',
            'monthly_only_description' => 'Crypto.com Pay hiện chỉ hỗ trợ chu kỳ thanh toán hàng tháng. Đăng ký hàng ngày, hàng tuần và hàng năm không được hỗ trợ.',
            'secret_key_placeholder' => 'Nhập Crypto.com Pay secret key của bạn',
            'secret_key_help' => 'Lấy từ Crypto.com Pay Dashboard',
            'webhook_url_help' => 'Thêm URL này vào cài đặt webhook Crypto.com Pay của bạn',
            'webhook_secret_placeholder' => 'Nhập webhook signing secret',
            'webhook_secret_help' => 'Bắt buộc để xác minh chữ ký webhook',
            'events_help' => 'Bật các sự kiện này trong Crypto.com Pay Dashboard:',
            'feature_crypto_fiat' => 'Chấp nhận thanh toán tiền điện tử và fiat',
            'feature_currencies' => 'Hơn 30 loại tiền tệ được hỗ trợ',
            'feature_renewal' => 'Tự động gia hạn đăng ký',
            'feature_signature_verification' => 'Xác minh chữ ký webhook HMAC SHA-256',
            'feature_monthly_only' => 'Chỉ chu kỳ hàng tháng (không hỗ trợ hàng ngày/hàng tuần/hàng năm)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'Yêu cầu phê duyệt thủ công',
            'manual_approval_description' => 'Thanh toán chuyển khoản ngân hàng yêu cầu xác minh thủ công. Người dùng sẽ thấy hướng dẫn bên dưới sau khi bắt đầu thanh toán. Quản trị viên phải phê duyệt hoặc từ chối thanh toán tại',
            'transactions_link' => 'Giao dịch',
            'instructions_title' => 'Hướng dẫn chuyển khoản ngân hàng',
            'instructions_label' => 'Hướng dẫn cho người dùng',
            'instructions_placeholder' => "Nhập thông tin tài khoản ngân hàng và hướng dẫn chuyển khoản tại đây...\n\nVí dụ:\n\nTên ngân hàng: Ngân hàng ABC\nTên tài khoản: Tên công ty của bạn\nSố tài khoản: 123456789\nMã Swift: ABCDEFGH\nTham chiếu: [Người dùng sẽ thấy ID đăng ký của họ]\n\nVui lòng bao gồm ID đăng ký trong tham chiếu thanh toán và gửi bằng chứng thanh toán qua email đến billing@yourcompany.com",
            'instructions_help' => 'Hướng dẫn này sẽ hiển thị cho người dùng sau khi họ chọn gói. Bao gồm thông tin tài khoản ngân hàng, định dạng tham chiếu và các bước xác minh.',
            'workflow_title' => 'Cách hoạt động thanh toán chuyển khoản:',
            'workflow_step_1' => 'Người dùng chọn gói và chọn Chuyển khoản ngân hàng làm phương thức thanh toán',
            'workflow_step_2' => 'Đăng ký và giao dịch đang chờ được tạo',
            'workflow_step_3' => 'Người dùng thấy hướng dẫn bạn đã cấu hình ở trên',
            'workflow_step_4' => 'Người dùng hoàn tất chuyển khoản ngân hàng thủ công',
            'workflow_step_5' => 'Quản trị viên nhận thông báo thanh toán đang chờ',
            'workflow_step_6' => 'Quản trị viên phê duyệt thanh toán → đăng ký được kích hoạt và tín dụng được nạp lại',
            'workflow_step_7' => 'Quản trị viên từ chối thanh toán → đăng ký và giao dịch bị xóa',
            'feature_currencies' => 'Hỗ trợ tất cả loại tiền tệ',
            'feature_intervals' => 'Hỗ trợ tất cả chu kỳ thanh toán (hàng ngày, hàng tuần, hàng tháng, hàng năm)',
            'feature_simple_setup' => 'Thiết lập đơn giản - không cần thông tin API',
            'feature_manual_verification' => 'Xác minh thủ công để bảo mật',
            'feature_no_fees' => 'Không phí giao dịch hoặc phụ thuộc bên thứ ba',
            'feature_admin_approval' => 'Yêu cầu phê duyệt quản trị cho mỗi thanh toán',
            'feature_no_renewal' => 'Không tự động gia hạn đăng ký',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'Tín dụng dựng không giới hạn',
    'feature_build_credits' => ':count tín dụng dựng',
    'feature_all_builders' => 'Truy cập tất cả builders đang hoạt động',
    'feature_builder_access' => 'Truy cập Builder',
    'feature_single_builder' => 'Truy cập một builder',
    'feature_multiple_builders' => 'Truy cập :count builders',
    'feature_custom_code' => 'Chèn CSS/JS tùy chỉnh',
    'feature_api_access' => 'Truy cập API',
    'feature_unlimited_hosted_pages' => 'Trang được lưu trữ không giới hạn',
    'feature_hosted_pages' => ':count trang được lưu trữ mỗi ứng dụng',
    'feature_hosted_pages_disabled' => 'Trang được lưu trữ',
    'feature_unlimited_ai_chat' => 'AI Chat không giới hạn',
    'feature_ai_tokens' => ':count token AI/tháng',
    'feature_own_ai_key' => 'Sử dụng API key AI riêng',
    'feature_ai_chat' => 'Trợ lý AI Chat',

    // Impersonation
    'impersonate' => 'Mạo danh',
    'impersonate_user' => 'Mạo danh người dùng',
    'impersonation_started' => 'Đang mạo danh :name',
    'impersonation_stopped' => 'Đã kết thúc mạo danh. Chào mừng trở lại!',
    'impersonating_as' => 'Đang xem với tư cách :name',
    'exit_impersonation' => 'Thoát',
    'return_to_admin' => 'Quay lại Quản trị',
    'not_impersonating' => 'Hiện không đang mạo danh người dùng nào.',
    'admin_blocked_during_impersonation' => 'Khu vực quản trị bị chặn khi đang mạo danh. Thoát mạo danh trước.',
    'impersonation_disabled_demo' => 'Mạo danh bị tắt trong chế độ demo.',
    'only_admins_can_impersonate' => 'Chỉ quản trị viên mới có thể mạo danh người dùng.',
];
