<x-app-layout>
    <x-slot name="title">{{ __('admin.system_settings') }}</x-slot>

    <!-- Page Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900 rounded-lg flex items-center justify-center">
                <svg class="w-5 h-5 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
            </div>
            <div>
                <h1 class="text-2xl font-bold text-gray-900 dark:text-white">{{ __('admin.system_settings') }}</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-1 hidden sm:block">
                    {{ __('admin.settings_subtitle_full') }}
                </p>
            </div>
        </div>
    </div>

    @php
        $settingsSections = [
            'general' => [
                'label' => __('admin.settings_section_general'),
                'keywords' => [
                    __('admin.settings_section_general'), __('admin.general_settings_title'), __('admin.site_name_label'), __('admin.site_description_label'), __('admin.site_tagline_label'), __('admin.logo_light'), __('admin.logo_dark_label'), __('admin.default_theme_label'), __('admin.currency_label'), __('admin.default_language'), __('admin.landing_page_toggle'),
                    'general', 'site', 'name', 'title', 'description', 'tagline', 'slogan', 'logo', 'light', 'dark', 'favicon', 'icon', 'theme', 'color', 'mode', 'landing', 'page', 'homepage', 'branding', 'brand', 'currency', 'money', 'usd', 'eur', 'language', 'locale', 'translation', 'purchase', 'code', 'license'
                ],
                'category' => 'platform'
            ],
            'plans' => [
                'label' => __('admin.settings_section_plans'),
                'keywords' => [
                    __('admin.settings_section_plans'), __('admin.plan_configuration'), __('admin.default_plan_label'),
                    'plan', 'plans', 'default', 'subscription', 'pricing', 'tier', 'free', 'pro', 'enterprise', 'new', 'user', 'registration', 'assign'
                ],
                'category' => 'platform'
            ],
            'auth' => [
                'label' => __('admin.settings_section_auth'),
                'keywords' => [
                    __('admin.settings_section_auth'), __('admin.auth_settings_title'), __('admin.enable_registration'), __('admin.require_email_verification'), __('admin.recaptcha_title'), __('admin.google_login'), __('admin.facebook_login'), __('admin.github_login'),
                    'auth', 'authentication', 'login', 'signin', 'sign-in', 'social', 'oauth', 'sso', 'google', 'facebook', 'github', 'recaptcha', 'captcha', 'bot', 'spam', 'register', 'registration', 'signup', 'sign-up', 'verification', 'verify', 'email', 'confirm', 'client', 'id', 'secret', 'callback'
                ],
                'category' => 'security'
            ],
            'email' => [
                'label' => __('admin.settings_section_email'),
                'keywords' => [
                    __('admin.settings_section_email'), __('admin.email_config_title'), __('admin.mail_driver'), __('admin.smtp_host'), __('admin.smtp_port'), __('admin.admin_notifications'), __('admin.send_test_email'),
                    'email', 'mail', 'smtp', 'mailer', 'sendmail', 'postfix', 'host', 'port', 'username', 'password', 'encryption', 'tls', 'ssl', 'from', 'address', 'sender', 'notification', 'notifications', 'admin', 'alert', 'test', 'send'
                ],
                'category' => 'security'
            ],
            'privacy' => [
                'label' => __('admin.settings_section_privacy'),
                'keywords' => [
                    __('admin.settings_section_privacy'), __('admin.gdpr_settings_title'), __('admin.enable_cookie_consent'), __('admin.enable_data_export'), __('admin.enable_account_deletion'), __('admin.audit_log_retention'),
                    'privacy', 'gdpr', 'compliance', 'cookie', 'cookies', 'consent', 'banner', 'data', 'export', 'download', 'deletion', 'delete', 'account', 'retention', 'policy', 'terms', 'service', 'audit', 'log', 'logs', 'grace', 'period', 'rate', 'limit'
                ],
                'category' => 'security'
            ],
            'preview' => [
                'label' => __('admin.settings_section_preview'),
                'keywords' => [
                    __('admin.settings_section_preview'), __('admin.appetize_settings_title'), __('admin.appetize_api_token'),
                    'preview', 'appetize', 'emulator', 'simulator', 'mobile', 'app', 'test', 'testing', 'demo', 'live', 'browser', 'api', 'token', 'upload', 'session', 'timeout', 'retention'
                ],
                'category' => 'integrations'
            ],
            'ai' => [
                'label' => __('admin.settings_section_ai'),
                'keywords' => [
                    __('admin.settings_section_ai'), __('admin.ai_settings_title'), __('admin.enable_ai'), __('admin.ai_provider'), __('admin.ai_model'), __('admin.enable_streaming'),
                    'ai', 'artificial', 'intelligence', 'chat', 'chatbot', 'assistant', 'openai', 'gpt', 'gpt-4', 'anthropic', 'claude', 'llm', 'model', 'token', 'tokens', 'streaming', 'stream', 'temperature', 'summarization', 'summary', 'widget', 'position', 'api', 'key'
                ],
                'category' => 'integrations'
            ]
        ];
        $settingsCategories = [
            'platform' => __('admin.settings_category_platform'),
            'security' => __('admin.settings_category_security'),
            'integrations' => __('admin.settings_category_integrations')
        ];
    @endphp

    <div class="flex flex-col lg:flex-row gap-6"
         x-data="{
             activeSection: window.location.hash ? window.location.hash.substring(1) : 'general',
             search: '',
             sections: {{ Js::from($settingsSections) }},
             categories: {{ Js::from($settingsCategories) }},
             init() {
                 window.addEventListener('hashchange', () => {
                     if (window.location.hash) {
                         this.activeSection = window.location.hash.substring(1);
                     }
                 });
             },
             switchSection(section) {
                 this.activeSection = section;
                 window.location.hash = section;
             },
             matchesSearch(keywords) {
                 if (!this.search || this.search.trim() === '') return true;
                 const searchTerms = this.search.toLowerCase().trim().split(/\s+/);
                 return searchTerms.every(term =>
                     keywords.some(keyword => keyword.toLowerCase().startsWith(term) || keyword.toLowerCase().includes(term))
                 );
             },
             getSectionsByCategory(category) {
                 return Object.entries(this.sections).filter(([key, sec]) => sec.category === category && this.matchesSearch(sec.keywords));
             },
             get hasResults() {
                 return Object.values(this.sections).some(sec => this.matchesSearch(sec.keywords));
             }
         }">

        <!-- Sidebar Card Navigation -->
        <div class="w-full lg:w-64 flex-shrink-0">
            <div class="bg-white border border-gray-200 rounded-lg shadow-xs dark:bg-gray-800 dark:border-gray-700 lg:sticky lg:top-4">
                <!-- Search -->
                <div class="p-4 border-b border-gray-200 dark:border-gray-700">
                    <div class="relative">
                        <div class="absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none">
                            <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                            </svg>
                        </div>
                        <input type="text"
                               x-model="search"
                               class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full ps-10 p-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
                               placeholder="{{ __('admin.search_settings') }}">
                    </div>
                </div>

                <!-- Navigation -->
                <nav class="p-4 space-y-4 max-h-96 lg:max-h-[calc(100vh-250px)] overflow-y-auto">
                    <template x-if="hasResults">
                        <div class="space-y-4">
                            <!-- Platform Category -->
                            <template x-if="getSectionsByCategory('platform').length > 0">
                                <div>
                                    <p class="mb-2 text-xs font-semibold text-gray-400 uppercase dark:text-gray-500" x-text="categories.platform"></p>
                                    <ul class="space-y-1">
                                        <template x-for="[key, section] in getSectionsByCategory('platform')" :key="key">
                                            <li>
                                                <button @click="switchSection(key)" type="button"
                                                        :class="activeSection === key ? 'text-white bg-blue-700' : 'text-gray-900 dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700'"
                                                        class="flex items-center p-2 w-full rounded-lg text-sm font-medium transition-colors text-start">
                                                    <span x-text="section.label"></span>
                                                </button>
                                            </li>
                                        </template>
                                    </ul>
                                </div>
                            </template>

                            <!-- Security Category -->
                            <template x-if="getSectionsByCategory('security').length > 0">
                                <div>
                                    <p class="mb-2 text-xs font-semibold text-gray-400 uppercase dark:text-gray-500" x-text="categories.security"></p>
                                    <ul class="space-y-1">
                                        <template x-for="[key, section] in getSectionsByCategory('security')" :key="key">
                                            <li>
                                                <button @click="switchSection(key)" type="button"
                                                        :class="activeSection === key ? 'text-white bg-blue-700' : 'text-gray-900 dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700'"
                                                        class="flex items-center p-2 w-full rounded-lg text-sm font-medium transition-colors text-start">
                                                    <span x-text="section.label"></span>
                                                </button>
                                            </li>
                                        </template>
                                    </ul>
                                </div>
                            </template>

                            <!-- Integrations Category -->
                            <template x-if="getSectionsByCategory('integrations').length > 0">
                                <div>
                                    <p class="mb-2 text-xs font-semibold text-gray-400 uppercase dark:text-gray-500" x-text="categories.integrations"></p>
                                    <ul class="space-y-1">
                                        <template x-for="[key, section] in getSectionsByCategory('integrations')" :key="key">
                                            <li>
                                                <button @click="switchSection(key)" type="button"
                                                        :class="activeSection === key ? 'text-white bg-blue-700' : 'text-gray-900 dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700'"
                                                        class="flex items-center p-2 w-full rounded-lg text-sm font-medium transition-colors text-start">
                                                    <span x-text="section.label"></span>
                                                </button>
                                            </li>
                                        </template>
                                    </ul>
                                </div>
                            </template>
                        </div>
                    </template>

                    <!-- No Results -->
                    <template x-if="!hasResults">
                        <div class="text-center py-4">
                            <svg class="w-10 h-10 text-gray-400 dark:text-gray-600 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                            </svg>
                            <p class="text-sm text-gray-500 dark:text-gray-400">{{ __('admin.no_settings_found') }}</p>
                            <button @click="search = ''" class="mt-2 text-xs text-blue-600 hover:text-blue-800 dark:text-blue-400">
                                {{ __('admin.clear_search') }}
                            </button>
                        </div>
                    </template>
                </nav>
            </div>
        </div>

        <!-- Settings Content -->
        <div class="flex-1 min-w-0">
            <!-- General Section -->
            <div x-show="activeSection === 'general'" x-cloak>
                <livewire:admin.general-settings-form />
            </div>

            <!-- Plans Section -->
            <div x-show="activeSection === 'plans'" x-cloak>
                <livewire:admin.app-settings-form />
            </div>

            <!-- Authentication Section -->
            <div x-show="activeSection === 'auth'" x-cloak>
                <livewire:admin.social-login-settings-form />
            </div>

            <!-- Email Section -->
            <div x-show="activeSection === 'email'" x-cloak>
                <livewire:admin.email-settings-form />
            </div>

            <!-- Privacy Section (GDPR) -->
            <div x-show="activeSection === 'privacy'" x-cloak>
                <livewire:admin.gdpr-settings-form />
            </div>

            <!-- Preview Section (Appetize) -->
            <div x-show="activeSection === 'preview'" x-cloak>
                <livewire:admin.appetize-settings-form />
            </div>

            <!-- AI Chat Section -->
            <div x-show="activeSection === 'ai'" x-cloak>
                <livewire:admin.ai-settings-form />
            </div>
        </div>
    </div>
</x-app-layout>
